/* ****************************************************************************
 *
 *	File: EncryptionHandlerState.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

// @author itenenbo

package com.adobe.internal.pdftoolkit.core.securityframework;

import javax.crypto.Cipher;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;

/**
 * Object of this type allows the caller to perform decryption/encryption sequentially
 * for parts of the processed data stream.
 * Object of this type is associated with the EncryptionHandler object and 
 * contain the current state of the decryption/encryption process for specific data. 
 */
public interface EncryptionHandlerState
{
	static final int DECRYPT = Cipher.DECRYPT_MODE;
	static final int ENCRYPT = Cipher.ENCRYPT_MODE;
	
	/*
	 * Starts the process of distributed decryption/encryption of specific data.
	 * @param buffer Contains the beginning portion of the processed data
	 * @param keyAddition Addition to the base encryption key for the peocessed data stream 
	 * @param mode	Decryption or Encryption Mode. 
	 * 				Must be one of the two static values defined in this interface.
	 * @return Decrypted or Encrypted portion of data
	 */
	byte[] init(byte[] buffer, int start, int len, byte[] keyAddition, int mode)
	throws PDFSecurityException;
	
	/**
	 * Continues the process of distributed decryption/encryption of specific data.
	 * @param buffer Contains the current portion of the processed data
	 * @return Decrypted or Encrypted portion of data
	 */
	byte[] update(byte[] buffer, int start, int len)
    throws PDFSecurityException;
	
	/**
	 * Finishes the process of distributed decryption/encryption of specific data.
	 * @return The final Decrypted or Encrypted portion of data
	 * @throws PDFSecurityException
	 */
	byte[] finish()
    throws PDFSecurityException;
}
