/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2006, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be coveredby   */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm;

import java.nio.ByteBuffer;

import com.adobe.versioncue.nativecomm.msg.BadMessageException;
import com.adobe.versioncue.nativecomm.msg.NCList;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCType;

/**
 * @author <a href="mailto:tnaroska@adobe.com">tnaroska</a>
 * @version $Revision: #1 $
 * @since Mar 9, 2006
 */
public interface IResult
{
	/**
	 * @return associated INativeService
	 * @deprecated use {@link #service()} instead
	 */
	@Deprecated INativeService processPool();

	/** @return associated INativeService */
	INativeService service();

	/** @return NativeService call name */
	String call();

	/**
	 * Result NCMap object
	 * 
	 * @return Result NCMap object
	 */
	NCMap results();

	/**
	 * Return named result.
	 * 
	 * @param key the result name
	 * @return the named result
	 */
	NCType get(String key);

	/**
	 * Return named result.
	 * 
	 * @param key the result name
	 * @return the named result
	 * @throws BadMessageException if the named result is not present or not of the correct type
	 */
	String getString(String key) throws BadMessageException;

	/**
	 * Return named result.
	 * 
	 * @param key the result name
	 * @return the named result
	 * @throws BadMessageException if the named result is not present or not of the correct type
	 */
	boolean getBool(String key) throws BadMessageException;

	/**
	 * Return named result.
	 * 
	 * @param key the result name
	 * @return the named result
	 * @throws BadMessageException if the named result is not present or not of the correct type
	 */
	double getDouble(String key) throws BadMessageException;

	/**
	 * Return named result.
	 * 
	 * @param key the result name
	 * @return the named result
	 * @throws BadMessageException if the named result is not present or not of the correct type
	 */
	int getInt(String key) throws BadMessageException;

	/**
	 * Return named result.
	 * 
	 * @param key the result name
	 * @return the named result
	 * @throws BadMessageException if the named result is not present or not of the correct type
	 */
	long getLong(String key) throws BadMessageException;

	/**
	 * Return named result.
	 * 
	 * @param key the result name
	 * @return the named result
	 * @throws BadMessageException if the named result is not present or not of the correct type
	 */
	byte[] getByteArray(String key) throws BadMessageException;

	/**
	 * Return named result.
	 * 
	 * @param key the result name
	 * @return the named result
	 * @throws BadMessageException if the named result is not present or not of the correct type
	 */
	ByteBuffer getBytes(String key) throws BadMessageException;

	/**
	 * Return named result.
	 * 
	 * @param key the result name
	 * @return the named result
	 * @throws BadMessageException if the named result is not present or not of the correct type
	 */
	NCMap getMap(String key) throws BadMessageException;

	/**
	 * Return named result.
	 * 
	 * @param key the result name
	 * @return the named result
	 * @throws BadMessageException if the named result is not present or not of the correct type
	 */
	NCList getList(String key) throws BadMessageException;
}
