/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa;

/**
 * A class holding information about the validity of an XFA node's
 * children, attributes or attribute values.
 */
public final class NodeValidationInfo {

	/**
	 * The node is invalid.
	 */
	public static final int NODE = 0;

	/**
	 * The attribute is invalid.
	 */
	public static final int ATTRIBUTE = 1;

	/**
	 * The value of attribute is invalid.
	 */
	public static final int ATTRIBUTEVALUE = 2;
	
	/**
	 * The rich text attribute or style value in aRichText is invalid
	 */
	public static final int RICHTEXT = 3;

	/**
	 * The invalid attribute, may be 0.
	 *
	 * @exclude from published api.
	 */
	public final int eAttr;

	/**
	 * The invalid enumerated value of the attribute
	 * specified by eAttr, may be 0.
	 *
	 * @exclude from published api.
	 */
	public final int eCurrentValue;
	
	/**
	 * The invalid attribute or value found within the XFARichTextNode stored in oNode
	 */
	public final String aRichText;

	/**
	 * The availability based on the validation type.
	 *
	 * @exclude from published api.
	 */
	public final int nAvailability;

	/**
	 * The version introduced based on the validation type.
	 *
	 * @exclude from published api.
	 */
	public final int nVersionIntro;

	/**
	 * The invalid node. If eAttr is not 0 this will be the parent
	 * of the attribute.
	 *
	 * @exclude from published api.
	 */
	public final Node oNode;
	
	NodeValidationInfo(int nVersionIntro, int nAvailability, Node oNode) {
		
		// getType() == NODE
		
		this.nVersionIntro = nVersionIntro;
		this.nAvailability = nAvailability;
		this.oNode = oNode;
		
		eAttr = 0;
		eCurrentValue = EnumAttr.UNDEFINED;
		
		aRichText = null;
	}

	/**
	 * @exclude from published api.
	 */
	NodeValidationInfo(int eAttr, int eCurrentValue, int nVersionIntro, int nAvailability, Node oNode) {
		
		assert eAttr != 0;
		// getType() == ATTRIBUTE || getType() == ATTRIBUTEVALUE
		
		this.nVersionIntro = nVersionIntro;
		this.nAvailability = nAvailability;
		this.oNode = oNode;
		
		this.eAttr = eAttr;
		this.eCurrentValue = eCurrentValue;
		
		aRichText = null;
	}
	
	NodeValidationInfo(String aRichText, int nVersionIntro, int nAvailability, Node oNode) {
		
		assert aRichText != null;
		
		// getType() == RICHTEXT
		
		this.nVersionIntro = nVersionIntro;
		this.nAvailability = nAvailability;
		this.oNode = oNode;
		
		eAttr = 0;
		eCurrentValue = EnumAttr.UNDEFINED;
		
		this.aRichText = aRichText;
	}

	/**
	 * Gets this object's validation info.
	 * 
	 * @return one of {@link #NODE NODE}, {@link #ATTRIBUTE ATTRIBUTE},
	 * or {@link #ATTRIBUTEVALUE ATTRIBUTEVALUE}.
	 */
	public int getType() {
		if (eAttr == 0) {
			if (aRichText == null)
				return NODE;
			else
				return RICHTEXT;
		}
		else if (eCurrentValue == EnumAttr.UNDEFINED)
			return ATTRIBUTE;
		else
			return ATTRIBUTEVALUE;
	}
}