/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.data;

import com.adobe.xfa.Arg;
import com.adobe.xfa.ModelScript;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;


/**
 * This class contains all the script functionality associated with the
 * Node class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class DataModelScript extends ModelScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ModelScript.moScriptTable,
		"dataModel",
		new ScriptPropObj[] {
			new ScriptPropObj(DataModelScript.class, "dataWindow", "getDataWindow", null, Arg.OBJECT, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_DATAMODEL_DATAWINDOW,0*/, 0)
		},
		null
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getDataWindow(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((DataModel) pObj).getDataWindow());
	}

}
