/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.formcalc;


/**
 * Class <b>Frame</b> defines the runtime frame table (stack)
 * 
 * @author Mike P. Tardif.
 *
 * @exclude from published api.
 */
public final class Frame {

    Frame() {
		// empty
	}


	public int getArgCount() {
		return moFuncSym.getCntValue();
	}


	public CalcSymbol getFuncSym() {
		return moFuncSym;
	}


	void setFuncSym(CalcSymbol oFuncSym) {
		moFuncSym = oFuncSym;
	}


	public int getStackAddr() {
		return mnStackAddr;
	}


	void setStackAddr(int nStackAddr) {
		mnStackAddr = nStackAddr;
	}


	int getReturnAddr() {
		return mnReturnAddr;
	}


	void setReturnAddr(int nInstruction) {
		mnReturnAddr = nInstruction;
	}


	private	CalcSymbol	moFuncSym;
	private	int 		mnStackAddr;
	private	int			mnReturnAddr;

}
