/*
 * Adobe Confidential
 * ------------------
 * Copyright 2005 Adobe Systems Incorporated.  All Rights Reserved.
 *
 * Notice: all information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any.  The intellectual and 
 * technical concepts contained herein are proprietary to Adobe Systems Inc.
 * and its suppliers and may be covered by U.S. and foreign patents, patents in 
 * process, and are protected by trade secret or copyright law.  Dissemination 
 * of this information or reproduction of this material is strictly forbidden 
 * unless prior written permission is obtained from Adobe Systems Incorporated.
 */
package com.adobe.xfa.svg;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;


/**
 * SVGTextData is
 * a class to represent the pcdata (#text) child in the SVG schema.
 *
 * @exclude from published api.
 */
public class SVGTextData extends TextNode {

    public SVGTextData(Element oParent, Node oNode, String text) {
		super(oParent, oNode, text);
	// Javaport: TODO
	//	setClassAtom(SVG.TEXTDATATAG, SVG.TEXTDATATAG);
	}
    
	/**
	 * @exclude from published api.
	 */
	public Node clone(Element parent) {
		return new SVGTextData(parent, parent.getLastXMLChild(), getValue());
	}

	/**
	 * Get the pcData for this node.
	 * @return the pcData as a string.
	 */
	public String getValue() {
		StringBuilder sReturn = new StringBuilder();
		if (getClassTag() == XFA.TEXTNODETAG)
			sReturn.append(super.getValue());
		else
			getValuesFromDom(sReturn, this);
		return sReturn.toString();
	}

	/**
	 * Set the pcdata for this node.
	 * @param sData a string containing the new pcdata.
	 */
	public void setValue(String sData) {
		super.setValue(sData, false, false);
		//
		// After a "set" operation we won't be a default property anymore, and
		// we'll no longer delegate to any protos.
		//
		makeNonDefault(false);
	}

	/**
	 * Cast this node to a string value.
	 * @return the string representing the pcdata.
	 */
	public String toString() {
		return getValue();
	}

	private void getValuesFromDom(StringBuilder textValue, Node oNode) {
	// Javaport: TODO
	//	textValue.append(oNode.getValue());
		Node child = oNode.getFirstXMLChild();
		while (child != null) {
			getValuesFromDom(textValue, child);
			child = child.getNextXMLSibling();
		}
	}

}
