package com.adobe.xfa.text;

/**
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public class TextCharProp {
	public final static int BREAK_MASK = 0x00003F;
	public final static int BREAK_SHIFT = 0;
	public final static int WIDTH_MASK = 0x0001C0;
	public final static int WIDTH_SHIFT = 6;
	public final static int GRAPHEME_MASK = 0x001E00;
	public final static int GRAPHEME_SHIFT = 9;
	public final static int WORD_MASK = 0x00E000;
	public final static int WORD_SHIFT = 13;
	public final static int CASE_MASK = 0x030000;
	public final static int CASE_SHIFT = 16;
	public final static int BIDI_MASK = 0x7C0000;
	public final static int BIDI_SHIFT = 18;
	public final static int BM_MASK = 0x800000;
	public final static int BM_SHIFT = 23;

	public final static int BREAK_AI = 0x00;
	public final static int BREAK_AL = 0x01;
	public final static int BREAK_B2 = 0x02;
	public final static int BREAK_BA = 0x03;
	public final static int BREAK_BB = 0x04;
	public final static int BREAK_BK = 0x05;
	public final static int BREAK_CB = 0x06;
	public final static int BREAK_CL = 0x07;
	public final static int BREAK_CM = 0x08;
	public final static int BREAK_CR = 0x09;
	public final static int BREAK_EX = 0x0A;
	public final static int BREAK_GL = 0x0B;
	public final static int BREAK_H2 = 0x0C;
	public final static int BREAK_H3 = 0x0D;
	public final static int BREAK_HY = 0x0E;
	public final static int BREAK_ID = 0x0F;
	public final static int BREAK_IN = 0x10;
	public final static int BREAK_IS = 0x11;
	public final static int BREAK_JL = 0x12;
	public final static int BREAK_JT = 0x13;
	public final static int BREAK_JV = 0x14;
	public final static int BREAK_LF = 0x15;
	public final static int BREAK_NL = 0x16;
	public final static int BREAK_NS = 0x17;
	public final static int BREAK_NU = 0x18;
	public final static int BREAK_OP = 0x19;
	public final static int BREAK_PO = 0x1A;
	public final static int BREAK_PR = 0x1B;
	public final static int BREAK_QU = 0x1C;
	public final static int BREAK_SA = 0x1D;
	public final static int BREAK_SG = 0x1E;
	public final static int BREAK_SP = 0x1F;
	public final static int BREAK_SY = 0x20;
	public final static int BREAK_WJ = 0x21;
	public final static int BREAK_XX = 0x22;
	public final static int BREAK_ZW = 0x23;

	public final static int WIDTH_A = 0x000;
	public final static int WIDTH_F = 0x040;
	public final static int WIDTH_H = 0x080;
	public final static int WIDTH_N = 0x0C0;
	public final static int WIDTH_Na = 0x100;
	public final static int WIDTH_W = 0x140;

	public final static int GRAPHEME_Control = 0x0000;
	public final static int GRAPHEME_CR = 0x0200;
	public final static int GRAPHEME_Default = 0x0400;
	public final static int GRAPHEME_Extend = 0x0600;
	public final static int GRAPHEME_L = 0x0800;
	public final static int GRAPHEME_LF = 0x0A00;
	public final static int GRAPHEME_LV = 0x0C00;
	public final static int GRAPHEME_LVT = 0x0E00;
	public final static int GRAPHEME_T = 0x1000;
	public final static int GRAPHEME_V = 0x1200;

	public final static int WORD_ALetter = 0x0000;
	public final static int WORD_Default = 0x2000;
	public final static int WORD_ExtendNumLet = 0x4000;
	public final static int WORD_Format = 0x6000;
	public final static int WORD_Katakana = 0x8000;
	public final static int WORD_MidLetter = 0xA000;
	public final static int WORD_MidNum = 0xC000;
	public final static int WORD_Numeric = 0xE000;

	public final static int CASE_Default = 0x00000;
	public final static int CASE_Lowercase = 0x10000;
	public final static int CASE_Titlecase = 0x20000;
	public final static int CASE_Uppercase = 0x30000;

	public final static int BIDI_AL = 0x000000;
	public final static int BIDI_AN = 0x040000;
	public final static int BIDI_B = 0x080000;
	public final static int BIDI_BN = 0x0C0000;
	public final static int BIDI_CS = 0x100000;
	public final static int BIDI_EN = 0x140000;
	public final static int BIDI_ES = 0x180000;
	public final static int BIDI_ET = 0x1C0000;
	public final static int BIDI_L = 0x200000;
	public final static int BIDI_LRE = 0x240000;
	public final static int BIDI_LRO = 0x280000;
	public final static int BIDI_NSM = 0x2C0000;
	public final static int BIDI_ON = 0x300000;
	public final static int BIDI_PDF = 0x340000;
	public final static int BIDI_R = 0x380000;
	public final static int BIDI_RLE = 0x3C0000;
	public final static int BIDI_RLO = 0x400000;
	public final static int BIDI_S = 0x440000;
	public final static int BIDI_WS = 0x480000;

	public final static int BM_OFF = 0x000000;
	public final static int BM_ON = 0x800000;

	public static final int defaultLetter = makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF);
	public final static int defaultSpace = makeData (BREAK_SP, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_WS, BM_OFF);
	public final static int defaultObject = makeData (BREAK_CB, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF);
	public final static int INVALID = 0x7FFFFFFF;

	public static final int BREAK_PROHIBIT = 0;
	public static final int BREAK_IF_SPACE = 1;
	public static final int BREAK_COMBINING_MARK = 2;
	public static final int BREAK_ALLOW = 3;

	static class CharPropRange {
		final int mcStart;
		final int mcEnd;
		final int meBreak;

		CharPropRange (int cStart, int cEnd, int eBreak) {
			mcStart = cStart;
			mcEnd = cEnd;
			meBreak = eBreak;
		}
	}

// For some reason, the Java compiler limits the size of static
// initializers, so this has to be a little more complex than in the C++
// version.  Moreover, that limit applies to method bodies as well, so
// initialization has to be split into two parts.
	private static class CharPropData {
		final CharPropRange[] mRanges;
		final BIDIMirrorData[] mBIDIMirrors = {
			new BIDIMirrorData (0x0028, 0x0029),
			new BIDIMirrorData (0x0029, 0x0028),
			new BIDIMirrorData (0x003C, 0x003E),
			new BIDIMirrorData (0x003E, 0x003C),
			new BIDIMirrorData (0x005B, 0x005D),
			new BIDIMirrorData (0x005D, 0x005B),
			new BIDIMirrorData (0x007B, 0x007D),
			new BIDIMirrorData (0x007D, 0x007B),
			new BIDIMirrorData (0x00AB, 0x00BB),
			new BIDIMirrorData (0x00BB, 0x00AB),
			new BIDIMirrorData (0x0F3A, 0x0F3B),
			new BIDIMirrorData (0x0F3B, 0x0F3A),
			new BIDIMirrorData (0x0F3C, 0x0F3D),
			new BIDIMirrorData (0x0F3D, 0x0F3C),
			new BIDIMirrorData (0x169B, 0x169C),
			new BIDIMirrorData (0x169C, 0x169B),
			new BIDIMirrorData (0x2018, 0x2019),
			new BIDIMirrorData (0x2019, 0x2018),
			new BIDIMirrorData (0x201C, 0x201D),
			new BIDIMirrorData (0x201D, 0x201C),
			new BIDIMirrorData (0x2039, 0x203A),
			new BIDIMirrorData (0x203A, 0x2039),
			new BIDIMirrorData (0x2045, 0x2046),
			new BIDIMirrorData (0x2046, 0x2045),
			new BIDIMirrorData (0x207D, 0x207E),
			new BIDIMirrorData (0x207E, 0x207D),
			new BIDIMirrorData (0x208D, 0x208E),
			new BIDIMirrorData (0x208E, 0x208D),
			new BIDIMirrorData (0x2208, 0x220B),
			new BIDIMirrorData (0x2209, 0x220C),
			new BIDIMirrorData (0x220A, 0x220D),
			new BIDIMirrorData (0x220B, 0x2208),
			new BIDIMirrorData (0x220C, 0x2209),
			new BIDIMirrorData (0x220D, 0x220A),
			new BIDIMirrorData (0x2215, 0x29F5),
			new BIDIMirrorData (0x223C, 0x223D),
			new BIDIMirrorData (0x223D, 0x223C),
			new BIDIMirrorData (0x2243, 0x22CD),
			new BIDIMirrorData (0x2252, 0x2253),
			new BIDIMirrorData (0x2253, 0x2252),
			new BIDIMirrorData (0x2254, 0x2255),
			new BIDIMirrorData (0x2255, 0x2254),
			new BIDIMirrorData (0x2264, 0x2265),
			new BIDIMirrorData (0x2265, 0x2264),
			new BIDIMirrorData (0x2266, 0x2267),
			new BIDIMirrorData (0x2267, 0x2266),
			new BIDIMirrorData (0x2268, 0x2269),
			new BIDIMirrorData (0x2269, 0x2268),
			new BIDIMirrorData (0x226A, 0x226B),
			new BIDIMirrorData (0x226B, 0x226A),
			new BIDIMirrorData (0x226E, 0x226F),
			new BIDIMirrorData (0x226F, 0x226E),
			new BIDIMirrorData (0x2270, 0x2271),
			new BIDIMirrorData (0x2271, 0x2270),
			new BIDIMirrorData (0x2272, 0x2273),
			new BIDIMirrorData (0x2273, 0x2272),
			new BIDIMirrorData (0x2274, 0x2275),
			new BIDIMirrorData (0x2275, 0x2274),
			new BIDIMirrorData (0x2276, 0x2277),
			new BIDIMirrorData (0x2277, 0x2276),
			new BIDIMirrorData (0x2278, 0x2279),
			new BIDIMirrorData (0x2279, 0x2278),
			new BIDIMirrorData (0x227A, 0x227B),
			new BIDIMirrorData (0x227B, 0x227A),
			new BIDIMirrorData (0x227C, 0x227D),
			new BIDIMirrorData (0x227D, 0x227C),
			new BIDIMirrorData (0x227E, 0x227F),
			new BIDIMirrorData (0x227F, 0x227E),
			new BIDIMirrorData (0x2280, 0x2281),
			new BIDIMirrorData (0x2281, 0x2280),
			new BIDIMirrorData (0x2282, 0x2283),
			new BIDIMirrorData (0x2283, 0x2282),
			new BIDIMirrorData (0x2284, 0x2285),
			new BIDIMirrorData (0x2285, 0x2284),
			new BIDIMirrorData (0x2286, 0x2287),
			new BIDIMirrorData (0x2287, 0x2286),
			new BIDIMirrorData (0x2288, 0x2289),
			new BIDIMirrorData (0x2289, 0x2288),
			new BIDIMirrorData (0x228A, 0x228B),
			new BIDIMirrorData (0x228B, 0x228A),
			new BIDIMirrorData (0x228F, 0x2290),
			new BIDIMirrorData (0x2290, 0x228F),
			new BIDIMirrorData (0x2291, 0x2292),
			new BIDIMirrorData (0x2292, 0x2291),
			new BIDIMirrorData (0x2298, 0x29B8),
			new BIDIMirrorData (0x22A2, 0x22A3),
			new BIDIMirrorData (0x22A3, 0x22A2),
			new BIDIMirrorData (0x22A6, 0x2ADE),
			new BIDIMirrorData (0x22A8, 0x2AE4),
			new BIDIMirrorData (0x22A9, 0x2AE3),
			new BIDIMirrorData (0x22AB, 0x2AE5),
			new BIDIMirrorData (0x22B0, 0x22B1),
			new BIDIMirrorData (0x22B1, 0x22B0),
			new BIDIMirrorData (0x22B2, 0x22B3),
			new BIDIMirrorData (0x22B3, 0x22B2),
			new BIDIMirrorData (0x22B4, 0x22B5),
			new BIDIMirrorData (0x22B5, 0x22B4),
			new BIDIMirrorData (0x22B6, 0x22B7),
			new BIDIMirrorData (0x22B7, 0x22B6),
			new BIDIMirrorData (0x22C9, 0x22CA),
			new BIDIMirrorData (0x22CA, 0x22C9),
			new BIDIMirrorData (0x22CB, 0x22CC),
			new BIDIMirrorData (0x22CC, 0x22CB),
			new BIDIMirrorData (0x22CD, 0x2243),
			new BIDIMirrorData (0x22D0, 0x22D1),
			new BIDIMirrorData (0x22D1, 0x22D0),
			new BIDIMirrorData (0x22D6, 0x22D7),
			new BIDIMirrorData (0x22D7, 0x22D6),
			new BIDIMirrorData (0x22D8, 0x22D9),
			new BIDIMirrorData (0x22D9, 0x22D8),
			new BIDIMirrorData (0x22DA, 0x22DB),
			new BIDIMirrorData (0x22DB, 0x22DA),
			new BIDIMirrorData (0x22DC, 0x22DD),
			new BIDIMirrorData (0x22DD, 0x22DC),
			new BIDIMirrorData (0x22DE, 0x22DF),
			new BIDIMirrorData (0x22DF, 0x22DE),
			new BIDIMirrorData (0x22E0, 0x22E1),
			new BIDIMirrorData (0x22E1, 0x22E0),
			new BIDIMirrorData (0x22E2, 0x22E3),
			new BIDIMirrorData (0x22E3, 0x22E2),
			new BIDIMirrorData (0x22E4, 0x22E5),
			new BIDIMirrorData (0x22E5, 0x22E4),
			new BIDIMirrorData (0x22E6, 0x22E7),
			new BIDIMirrorData (0x22E7, 0x22E6),
			new BIDIMirrorData (0x22E8, 0x22E9),
			new BIDIMirrorData (0x22E9, 0x22E8),
			new BIDIMirrorData (0x22EA, 0x22EB),
			new BIDIMirrorData (0x22EB, 0x22EA),
			new BIDIMirrorData (0x22EC, 0x22ED),
			new BIDIMirrorData (0x22ED, 0x22EC),
			new BIDIMirrorData (0x22F0, 0x22F1),
			new BIDIMirrorData (0x22F1, 0x22F0),
			new BIDIMirrorData (0x22F2, 0x22FA),
			new BIDIMirrorData (0x22F3, 0x22FB),
			new BIDIMirrorData (0x22F4, 0x22FC),
			new BIDIMirrorData (0x22F6, 0x22FD),
			new BIDIMirrorData (0x22F7, 0x22FE),
			new BIDIMirrorData (0x22FA, 0x22F2),
			new BIDIMirrorData (0x22FB, 0x22F3),
			new BIDIMirrorData (0x22FC, 0x22F4),
			new BIDIMirrorData (0x22FD, 0x22F6),
			new BIDIMirrorData (0x22FE, 0x22F7),
			new BIDIMirrorData (0x2308, 0x2309),
			new BIDIMirrorData (0x2309, 0x2308),
			new BIDIMirrorData (0x230A, 0x230B),
			new BIDIMirrorData (0x230B, 0x230A),
			new BIDIMirrorData (0x2329, 0x232A),
			new BIDIMirrorData (0x232A, 0x2329),
			new BIDIMirrorData (0x2768, 0x2769),
			new BIDIMirrorData (0x2769, 0x2768),
			new BIDIMirrorData (0x276A, 0x276B),
			new BIDIMirrorData (0x276B, 0x276A),
			new BIDIMirrorData (0x276C, 0x276D),
			new BIDIMirrorData (0x276D, 0x276C),
			new BIDIMirrorData (0x276E, 0x276F),
			new BIDIMirrorData (0x276F, 0x276E),
			new BIDIMirrorData (0x2770, 0x2771),
			new BIDIMirrorData (0x2771, 0x2770),
			new BIDIMirrorData (0x2772, 0x2773),
			new BIDIMirrorData (0x2773, 0x2772),
			new BIDIMirrorData (0x2774, 0x2775),
			new BIDIMirrorData (0x2775, 0x2774),
			new BIDIMirrorData (0x27C3, 0x27C4),
			new BIDIMirrorData (0x27C4, 0x27C3),
			new BIDIMirrorData (0x27C5, 0x27C6),
			new BIDIMirrorData (0x27C6, 0x27C5),
			new BIDIMirrorData (0x27D5, 0x27D6),
			new BIDIMirrorData (0x27D6, 0x27D5),
			new BIDIMirrorData (0x27DD, 0x27DE),
			new BIDIMirrorData (0x27DE, 0x27DD),
			new BIDIMirrorData (0x27E2, 0x27E3),
			new BIDIMirrorData (0x27E3, 0x27E2),
			new BIDIMirrorData (0x27E4, 0x27E5),
			new BIDIMirrorData (0x27E5, 0x27E4),
			new BIDIMirrorData (0x27E6, 0x27E7),
			new BIDIMirrorData (0x27E7, 0x27E6),
			new BIDIMirrorData (0x27E8, 0x27E9),
			new BIDIMirrorData (0x27E9, 0x27E8),
			new BIDIMirrorData (0x27EA, 0x27EB),
			new BIDIMirrorData (0x27EB, 0x27EA),
			new BIDIMirrorData (0x2983, 0x2984),
			new BIDIMirrorData (0x2984, 0x2983),
			new BIDIMirrorData (0x2985, 0x2986),
			new BIDIMirrorData (0x2986, 0x2985),
			new BIDIMirrorData (0x2987, 0x2988),
			new BIDIMirrorData (0x2988, 0x2987),
			new BIDIMirrorData (0x2989, 0x298A),
			new BIDIMirrorData (0x298A, 0x2989),
			new BIDIMirrorData (0x298B, 0x298C),
			new BIDIMirrorData (0x298C, 0x298B),
			new BIDIMirrorData (0x298D, 0x2990),
			new BIDIMirrorData (0x298E, 0x298F),
			new BIDIMirrorData (0x298F, 0x298E),
			new BIDIMirrorData (0x2990, 0x298D),
			new BIDIMirrorData (0x2991, 0x2992),
			new BIDIMirrorData (0x2992, 0x2991),
			new BIDIMirrorData (0x2993, 0x2994),
			new BIDIMirrorData (0x2994, 0x2993),
			new BIDIMirrorData (0x2995, 0x2996),
			new BIDIMirrorData (0x2996, 0x2995),
			new BIDIMirrorData (0x2997, 0x2998),
			new BIDIMirrorData (0x2998, 0x2997),
			new BIDIMirrorData (0x29B8, 0x2298),
			new BIDIMirrorData (0x29C0, 0x29C1),
			new BIDIMirrorData (0x29C1, 0x29C0),
			new BIDIMirrorData (0x29C4, 0x29C5),
			new BIDIMirrorData (0x29C5, 0x29C4),
			new BIDIMirrorData (0x29CF, 0x29D0),
			new BIDIMirrorData (0x29D0, 0x29CF),
			new BIDIMirrorData (0x29D1, 0x29D2),
			new BIDIMirrorData (0x29D2, 0x29D1),
			new BIDIMirrorData (0x29D4, 0x29D5),
			new BIDIMirrorData (0x29D5, 0x29D4),
			new BIDIMirrorData (0x29D8, 0x29D9),
			new BIDIMirrorData (0x29D9, 0x29D8),
			new BIDIMirrorData (0x29DA, 0x29DB),
			new BIDIMirrorData (0x29DB, 0x29DA),
			new BIDIMirrorData (0x29F5, 0x2215),
			new BIDIMirrorData (0x29F8, 0x29F9),
			new BIDIMirrorData (0x29F9, 0x29F8),
			new BIDIMirrorData (0x29FC, 0x29FD),
			new BIDIMirrorData (0x29FD, 0x29FC),
			new BIDIMirrorData (0x2A2B, 0x2A2C),
			new BIDIMirrorData (0x2A2C, 0x2A2B),
			new BIDIMirrorData (0x2A2D, 0x2A2E),
			new BIDIMirrorData (0x2A2E, 0x2A2D),
			new BIDIMirrorData (0x2A34, 0x2A35),
			new BIDIMirrorData (0x2A35, 0x2A34),
			new BIDIMirrorData (0x2A3C, 0x2A3D),
			new BIDIMirrorData (0x2A3D, 0x2A3C),
			new BIDIMirrorData (0x2A64, 0x2A65),
			new BIDIMirrorData (0x2A65, 0x2A64),
			new BIDIMirrorData (0x2A79, 0x2A7A),
			new BIDIMirrorData (0x2A7A, 0x2A79),
			new BIDIMirrorData (0x2A7D, 0x2A7E),
			new BIDIMirrorData (0x2A7E, 0x2A7D),
			new BIDIMirrorData (0x2A7F, 0x2A80),
			new BIDIMirrorData (0x2A80, 0x2A7F),
			new BIDIMirrorData (0x2A81, 0x2A82),
			new BIDIMirrorData (0x2A82, 0x2A81),
			new BIDIMirrorData (0x2A83, 0x2A84),
			new BIDIMirrorData (0x2A84, 0x2A83),
			new BIDIMirrorData (0x2A8B, 0x2A8C),
			new BIDIMirrorData (0x2A8C, 0x2A8B),
			new BIDIMirrorData (0x2A91, 0x2A92),
			new BIDIMirrorData (0x2A92, 0x2A91),
			new BIDIMirrorData (0x2A93, 0x2A94),
			new BIDIMirrorData (0x2A94, 0x2A93),
			new BIDIMirrorData (0x2A95, 0x2A96),
			new BIDIMirrorData (0x2A96, 0x2A95),
			new BIDIMirrorData (0x2A97, 0x2A98),
			new BIDIMirrorData (0x2A98, 0x2A97),
			new BIDIMirrorData (0x2A99, 0x2A9A),
			new BIDIMirrorData (0x2A9A, 0x2A99),
			new BIDIMirrorData (0x2A9B, 0x2A9C),
			new BIDIMirrorData (0x2A9C, 0x2A9B),
			new BIDIMirrorData (0x2AA1, 0x2AA2),
			new BIDIMirrorData (0x2AA2, 0x2AA1),
			new BIDIMirrorData (0x2AA6, 0x2AA7),
			new BIDIMirrorData (0x2AA7, 0x2AA6),
			new BIDIMirrorData (0x2AA8, 0x2AA9),
			new BIDIMirrorData (0x2AA9, 0x2AA8),
			new BIDIMirrorData (0x2AAA, 0x2AAB),
			new BIDIMirrorData (0x2AAB, 0x2AAA),
			new BIDIMirrorData (0x2AAC, 0x2AAD),
			new BIDIMirrorData (0x2AAD, 0x2AAC),
			new BIDIMirrorData (0x2AAF, 0x2AB0),
			new BIDIMirrorData (0x2AB0, 0x2AAF),
			new BIDIMirrorData (0x2AB3, 0x2AB4),
			new BIDIMirrorData (0x2AB4, 0x2AB3),
			new BIDIMirrorData (0x2ABB, 0x2ABC),
			new BIDIMirrorData (0x2ABC, 0x2ABB),
			new BIDIMirrorData (0x2ABD, 0x2ABE),
			new BIDIMirrorData (0x2ABE, 0x2ABD),
			new BIDIMirrorData (0x2ABF, 0x2AC0),
			new BIDIMirrorData (0x2AC0, 0x2ABF),
			new BIDIMirrorData (0x2AC1, 0x2AC2),
			new BIDIMirrorData (0x2AC2, 0x2AC1),
			new BIDIMirrorData (0x2AC3, 0x2AC4),
			new BIDIMirrorData (0x2AC4, 0x2AC3),
			new BIDIMirrorData (0x2AC5, 0x2AC6),
			new BIDIMirrorData (0x2AC6, 0x2AC5),
			new BIDIMirrorData (0x2ACD, 0x2ACE),
			new BIDIMirrorData (0x2ACE, 0x2ACD),
			new BIDIMirrorData (0x2ACF, 0x2AD0),
			new BIDIMirrorData (0x2AD0, 0x2ACF),
			new BIDIMirrorData (0x2AD1, 0x2AD2),
			new BIDIMirrorData (0x2AD2, 0x2AD1),
			new BIDIMirrorData (0x2AD3, 0x2AD4),
			new BIDIMirrorData (0x2AD4, 0x2AD3),
			new BIDIMirrorData (0x2AD5, 0x2AD6),
			new BIDIMirrorData (0x2AD6, 0x2AD5),
			new BIDIMirrorData (0x2ADE, 0x22A6),
			new BIDIMirrorData (0x2AE3, 0x22A9),
			new BIDIMirrorData (0x2AE4, 0x22A8),
			new BIDIMirrorData (0x2AE5, 0x22AB),
			new BIDIMirrorData (0x2AEC, 0x2AED),
			new BIDIMirrorData (0x2AED, 0x2AEC),
			new BIDIMirrorData (0x2AF7, 0x2AF8),
			new BIDIMirrorData (0x2AF8, 0x2AF7),
			new BIDIMirrorData (0x2AF9, 0x2AFA),
			new BIDIMirrorData (0x2AFA, 0x2AF9),
			new BIDIMirrorData (0x2E02, 0x2E03),
			new BIDIMirrorData (0x2E03, 0x2E02),
			new BIDIMirrorData (0x2E04, 0x2E05),
			new BIDIMirrorData (0x2E05, 0x2E04),
			new BIDIMirrorData (0x2E09, 0x2E0A),
			new BIDIMirrorData (0x2E0A, 0x2E09),
			new BIDIMirrorData (0x2E0C, 0x2E0D),
			new BIDIMirrorData (0x2E0D, 0x2E0C),
			new BIDIMirrorData (0x2E1C, 0x2E1D),
			new BIDIMirrorData (0x2E1D, 0x2E1C),
			new BIDIMirrorData (0x3008, 0x3009),
			new BIDIMirrorData (0x3009, 0x3008),
			new BIDIMirrorData (0x300A, 0x300B),
			new BIDIMirrorData (0x300B, 0x300A),
			new BIDIMirrorData (0x300C, 0x300D),
			new BIDIMirrorData (0x300D, 0x300C),
			new BIDIMirrorData (0x300E, 0x300F),
			new BIDIMirrorData (0x300F, 0x300E),
			new BIDIMirrorData (0x3010, 0x3011),
			new BIDIMirrorData (0x3011, 0x3010),
			new BIDIMirrorData (0x3014, 0x3015),
			new BIDIMirrorData (0x3015, 0x3014),
			new BIDIMirrorData (0x3016, 0x3017),
			new BIDIMirrorData (0x3017, 0x3016),
			new BIDIMirrorData (0x3018, 0x3019),
			new BIDIMirrorData (0x3019, 0x3018),
			new BIDIMirrorData (0x301A, 0x301B),
			new BIDIMirrorData (0x301B, 0x301A),
			new BIDIMirrorData (0x301D, 0x301E),
			new BIDIMirrorData (0x301E, 0x301D),
			new BIDIMirrorData (0xFE59, 0xFE5A),
			new BIDIMirrorData (0xFE5A, 0xFE59),
			new BIDIMirrorData (0xFE5B, 0xFE5C),
			new BIDIMirrorData (0xFE5C, 0xFE5B),
			new BIDIMirrorData (0xFE5D, 0xFE5E),
			new BIDIMirrorData (0xFE5E, 0xFE5D),
			new BIDIMirrorData (0xFE64, 0xFE65),
			new BIDIMirrorData (0xFE65, 0xFE64),
			new BIDIMirrorData (0xFF08, 0xFF09),
			new BIDIMirrorData (0xFF09, 0xFF08),
			new BIDIMirrorData (0xFF1C, 0xFF1E),
			new BIDIMirrorData (0xFF1E, 0xFF1C),
			new BIDIMirrorData (0xFF3B, 0xFF3D),
			new BIDIMirrorData (0xFF3D, 0xFF3B),
			new BIDIMirrorData (0xFF5B, 0xFF5D),
			new BIDIMirrorData (0xFF5D, 0xFF5B),
			new BIDIMirrorData (0xFF5F, 0xFF60),
			new BIDIMirrorData (0xFF60, 0xFF5F),
			new BIDIMirrorData (0xFF62, 0xFF63),
			new BIDIMirrorData (0xFF63, 0xFF62),
		};

		CharPropData () {
			mRanges = new CharPropRange[3336];	// NOTE: hard-coded constant will have to be updated if table changes

			int i = 0;
			i = initialize1 (i);
			i = initialize2 (i);
			i = initialize3 (i);
			i = initialize4 (i);
			i = initialize5 (i);
			i = initialize6 (i);
			i = initialize7 (i);
		}

		private int initialize1 (int i) {
			mRanges[i++] = new CharPropRange (0x0000, 0x0008, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0009, 0x0009, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_S, BM_OFF));
			mRanges[i++] = new CharPropRange (0x000A, 0x000A, makeData (BREAK_LF, WIDTH_N, GRAPHEME_LF, WORD_Default, CASE_Default, BIDI_B, BM_OFF));
			mRanges[i++] = new CharPropRange (0x000B, 0x000B, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_S, BM_OFF));
			mRanges[i++] = new CharPropRange (0x000C, 0x000C, makeData (BREAK_BK, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_WS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x000D, 0x000D, makeData (BREAK_CR, WIDTH_N, GRAPHEME_CR, WORD_Default, CASE_Default, BIDI_B, BM_OFF));
			mRanges[i++] = new CharPropRange (0x000E, 0x001B, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x001C, 0x001E, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_B, BM_OFF));
			mRanges[i++] = new CharPropRange (0x001F, 0x001F, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_S, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0020, 0x0020, makeData (BREAK_SP, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_WS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0021, 0x0021, makeData (BREAK_EX, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0022, 0x0022, makeData (BREAK_QU, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0023, 0x0023, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0024, 0x0024, makeData (BREAK_PR, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0025, 0x0025, makeData (BREAK_PO, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0026, 0x0026, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0027, 0x0027, makeData (BREAK_QU, WIDTH_Na, GRAPHEME_Default, WORD_MidLetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0028, 0x0028, makeData (BREAK_OP, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x0029, 0x0029, makeData (BREAK_CL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x002A, 0x002A, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x002B, 0x002B, makeData (BREAK_PR, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ES, BM_OFF));
			mRanges[i++] = new CharPropRange (0x002C, 0x002C, makeData (BREAK_IS, WIDTH_Na, GRAPHEME_Default, WORD_MidNum, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x002D, 0x002D, makeData (BREAK_HY, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ES, BM_OFF));
			mRanges[i++] = new CharPropRange (0x002E, 0x002E, makeData (BREAK_IS, WIDTH_Na, GRAPHEME_Default, WORD_MidNum, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x002F, 0x002F, makeData (BREAK_SY, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0030, 0x0039, makeData (BREAK_NU, WIDTH_Na, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x003A, 0x003A, makeData (BREAK_IS, WIDTH_Na, GRAPHEME_Default, WORD_MidLetter, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x003B, 0x003B, makeData (BREAK_IS, WIDTH_Na, GRAPHEME_Default, WORD_MidNum, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x003C, 0x003C, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x003D, 0x003D, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x003E, 0x003E, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x003F, 0x003F, makeData (BREAK_EX, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0040, 0x0040, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0041, 0x005A, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x005B, 0x005B, makeData (BREAK_OP, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x005C, 0x005C, makeData (BREAK_PR, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x005D, 0x005D, makeData (BREAK_CL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x005E, 0x005E, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x005F, 0x005F, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_ExtendNumLet, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0060, 0x0060, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0061, 0x007A, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x007B, 0x007B, makeData (BREAK_OP, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x007C, 0x007C, makeData (BREAK_BA, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x007D, 0x007D, makeData (BREAK_CL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x007E, 0x007E, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x007F, 0x0084, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0085, 0x0085, makeData (BREAK_NL, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_B, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0086, 0x009F, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00A0, 0x00A0, makeData (BREAK_GL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00A1, 0x00A1, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00A2, 0x00A2, makeData (BREAK_PO, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00A3, 0x00A3, makeData (BREAK_PR, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00A4, 0x00A4, makeData (BREAK_PR, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00A5, 0x00A5, makeData (BREAK_PR, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00A6, 0x00A6, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00A7, 0x00A8, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00A9, 0x00A9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00AA, 0x00AA, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00AB, 0x00AB, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x00AC, 0x00AC, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00AD, 0x00AD, makeData (BREAK_BA, WIDTH_A, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00AE, 0x00AE, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00AF, 0x00AF, makeData (BREAK_AL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00B0, 0x00B0, makeData (BREAK_PO, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00B1, 0x00B1, makeData (BREAK_PR, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00B2, 0x00B3, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00B4, 0x00B4, makeData (BREAK_BB, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00B5, 0x00B5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00B6, 0x00B6, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00B7, 0x00B7, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_MidLetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00B8, 0x00B8, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00B9, 0x00B9, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00BA, 0x00BA, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00BB, 0x00BB, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x00BC, 0x00BF, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00C0, 0x00C5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00C6, 0x00C6, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00C7, 0x00CF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00D0, 0x00D0, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00D1, 0x00D6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00D7, 0x00D7, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00D8, 0x00D8, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00D9, 0x00DD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00DE, 0x00DE, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00DF, 0x00E1, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00E2, 0x00E5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00E6, 0x00E6, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00E7, 0x00E7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00E8, 0x00EA, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00EB, 0x00EB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00EC, 0x00ED, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00EE, 0x00EF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00F0, 0x00F0, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00F1, 0x00F1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00F2, 0x00F3, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00F4, 0x00F6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00F7, 0x00F7, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00F8, 0x00FA, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00FB, 0x00FB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00FC, 0x00FC, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00FD, 0x00FD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00FE, 0x00FE, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x00FF, 0x00FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0100, 0x0100, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0101, 0x0101, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0102, 0x0102, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0103, 0x0103, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0104, 0x0104, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0105, 0x0105, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0106, 0x0106, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0107, 0x0107, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0108, 0x0108, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0109, 0x0109, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x010A, 0x010A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x010B, 0x010B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x010C, 0x010C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x010D, 0x010D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x010E, 0x010E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x010F, 0x010F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0110, 0x0110, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0111, 0x0111, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0112, 0x0112, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0113, 0x0113, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0114, 0x0114, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0115, 0x0115, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0116, 0x0116, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0117, 0x0117, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0118, 0x0118, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0119, 0x0119, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x011A, 0x011A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x011B, 0x011B, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x011C, 0x011C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x011D, 0x011D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x011E, 0x011E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x011F, 0x011F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0120, 0x0120, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0121, 0x0121, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0122, 0x0122, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0123, 0x0123, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0124, 0x0124, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0125, 0x0125, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0126, 0x0126, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0127, 0x0127, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0128, 0x0128, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0129, 0x0129, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x012A, 0x012A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x012B, 0x012B, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x012C, 0x012C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x012D, 0x012D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x012E, 0x012E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x012F, 0x012F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0130, 0x0130, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0131, 0x0131, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0132, 0x0132, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0133, 0x0133, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0134, 0x0134, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0135, 0x0135, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0136, 0x0136, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0137, 0x0137, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0138, 0x0138, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0139, 0x0139, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x013A, 0x013A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x013B, 0x013B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x013C, 0x013C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x013D, 0x013D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x013E, 0x013E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x013F, 0x013F, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0140, 0x0140, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0141, 0x0141, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0142, 0x0142, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0143, 0x0143, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0144, 0x0144, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0145, 0x0145, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0146, 0x0146, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0147, 0x0147, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0148, 0x0149, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x014A, 0x014A, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x014B, 0x014B, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x014C, 0x014C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x014D, 0x014D, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x014E, 0x014E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x014F, 0x014F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0150, 0x0150, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0151, 0x0151, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0152, 0x0152, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0153, 0x0153, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0154, 0x0154, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0155, 0x0155, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0156, 0x0156, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0157, 0x0157, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0158, 0x0158, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0159, 0x0159, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x015A, 0x015A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x015B, 0x015B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x015C, 0x015C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x015D, 0x015D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x015E, 0x015E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x015F, 0x015F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0160, 0x0160, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0161, 0x0161, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0162, 0x0162, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0163, 0x0163, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0164, 0x0164, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0165, 0x0165, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0166, 0x0166, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0167, 0x0167, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0168, 0x0168, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0169, 0x0169, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x016A, 0x016A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x016B, 0x016B, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x016C, 0x016C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x016D, 0x016D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x016E, 0x016E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x016F, 0x016F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0170, 0x0170, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0171, 0x0171, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0172, 0x0172, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0173, 0x0173, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0174, 0x0174, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0175, 0x0175, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0176, 0x0176, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0177, 0x0177, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0178, 0x0179, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x017A, 0x017A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x017B, 0x017B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x017C, 0x017C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x017D, 0x017D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x017E, 0x0180, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0181, 0x0182, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0183, 0x0183, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0184, 0x0184, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0185, 0x0185, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0186, 0x0187, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0188, 0x0188, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0189, 0x018B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x018C, 0x018D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x018E, 0x0191, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0192, 0x0192, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0193, 0x0194, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0195, 0x0195, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0196, 0x0198, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0199, 0x019B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x019C, 0x019D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x019E, 0x019E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x019F, 0x01A0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01A1, 0x01A1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01A2, 0x01A2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01A3, 0x01A3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01A4, 0x01A4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01A5, 0x01A5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01A6, 0x01A7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01A8, 0x01A8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01A9, 0x01A9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01AA, 0x01AB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01AC, 0x01AC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01AD, 0x01AD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01AE, 0x01AF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01B0, 0x01B0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01B1, 0x01B3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01B4, 0x01B4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01B5, 0x01B5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01B6, 0x01B6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01B7, 0x01B8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01B9, 0x01BA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01BB, 0x01BB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01BC, 0x01BC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01BD, 0x01BF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01C0, 0x01C3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01C4, 0x01C4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01C5, 0x01C5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Titlecase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01C6, 0x01C6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01C7, 0x01C7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01C8, 0x01C8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Titlecase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01C9, 0x01C9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01CA, 0x01CA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01CB, 0x01CB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Titlecase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01CC, 0x01CC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01CD, 0x01CD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01CE, 0x01CE, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01CF, 0x01CF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01D0, 0x01D0, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01D1, 0x01D1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01D2, 0x01D2, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01D3, 0x01D3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01D4, 0x01D4, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01D5, 0x01D5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01D6, 0x01D6, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01D7, 0x01D7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01D8, 0x01D8, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01D9, 0x01D9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01DA, 0x01DA, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01DB, 0x01DB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01DC, 0x01DC, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01DD, 0x01DD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01DE, 0x01DE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01DF, 0x01DF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01E0, 0x01E0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01E1, 0x01E1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01E2, 0x01E2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01E3, 0x01E3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01E4, 0x01E4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01E5, 0x01E5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01E6, 0x01E6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01E7, 0x01E7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01E8, 0x01E8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01E9, 0x01E9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01EA, 0x01EA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01EB, 0x01EB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01EC, 0x01EC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01ED, 0x01ED, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01EE, 0x01EE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01EF, 0x01F0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01F1, 0x01F1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01F2, 0x01F2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Titlecase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01F3, 0x01F3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01F4, 0x01F4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01F5, 0x01F5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01F6, 0x01F8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01F9, 0x01F9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01FA, 0x01FA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01FB, 0x01FB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01FC, 0x01FC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01FD, 0x01FD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01FE, 0x01FE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x01FF, 0x01FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0200, 0x0200, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0201, 0x0201, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0202, 0x0202, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0203, 0x0203, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0204, 0x0204, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0205, 0x0205, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0206, 0x0206, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0207, 0x0207, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0208, 0x0208, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0209, 0x0209, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x020A, 0x020A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x020B, 0x020B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x020C, 0x020C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x020D, 0x020D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x020E, 0x020E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x020F, 0x020F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0210, 0x0210, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0211, 0x0211, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0212, 0x0212, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0213, 0x0213, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0214, 0x0214, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0215, 0x0215, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0216, 0x0216, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0217, 0x0217, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0218, 0x0218, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0219, 0x0219, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x021A, 0x021A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x021B, 0x021B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x021C, 0x021C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x021D, 0x021D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x021E, 0x021E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x021F, 0x021F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0220, 0x0220, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0221, 0x0221, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0222, 0x0222, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0223, 0x0223, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0224, 0x0224, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0225, 0x0225, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0226, 0x0226, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0227, 0x0227, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0228, 0x0228, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0229, 0x0229, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x022A, 0x022A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x022B, 0x022B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x022C, 0x022C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x022D, 0x022D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x022E, 0x022E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x022F, 0x022F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0230, 0x0230, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0231, 0x0231, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0232, 0x0232, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0233, 0x0239, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x023A, 0x023B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x023C, 0x023C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x023D, 0x023E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x023F, 0x0240, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0241, 0x0241, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0242, 0x0242, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0243, 0x0246, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0247, 0x0247, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0248, 0x0248, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0249, 0x0249, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x024A, 0x024A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x024B, 0x024B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x024C, 0x024C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x024D, 0x024D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x024E, 0x024E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x024F, 0x024F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0250, 0x0250, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0251, 0x0251, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0252, 0x0260, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0261, 0x0261, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0262, 0x0293, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0294, 0x0294, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0295, 0x02B8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02B9, 0x02BA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02BB, 0x02BF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02C0, 0x02C1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02C2, 0x02C3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02C4, 0x02C4, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02C5, 0x02C5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02C6, 0x02C6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02C7, 0x02C7, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02C8, 0x02C8, makeData (BREAK_BB, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02C9, 0x02CB, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02CC, 0x02CC, makeData (BREAK_BB, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02CD, 0x02CD, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02CE, 0x02CF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02D0, 0x02D0, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02D1, 0x02D1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02D2, 0x02D7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02D8, 0x02DB, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02DC, 0x02DC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02DD, 0x02DD, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02DE, 0x02DE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02DF, 0x02DF, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02E0, 0x02E4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02E5, 0x02ED, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02EE, 0x02EE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x02EF, 0x02FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0300, 0x0344, makeData (BREAK_CM, WIDTH_A, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0345, 0x0345, makeData (BREAK_CM, WIDTH_A, GRAPHEME_Extend, WORD_Default, CASE_Lowercase, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0346, 0x034E, makeData (BREAK_CM, WIDTH_A, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x034F, 0x034F, makeData (BREAK_GL, WIDTH_A, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0350, 0x035C, makeData (BREAK_CM, WIDTH_A, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x035D, 0x0362, makeData (BREAK_GL, WIDTH_A, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0363, 0x036F, makeData (BREAK_CM, WIDTH_A, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0374, 0x0375, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x037A, 0x037A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x037B, 0x037D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x037E, 0x037E, makeData (BREAK_IS, WIDTH_N, GRAPHEME_Default, WORD_MidNum, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0384, 0x0385, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0386, 0x0386, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0387, 0x0387, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0388, 0x038A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x038C, 0x038C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x038E, 0x038F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0390, 0x0390, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0391, 0x03A1, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03A3, 0x03A9, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03AA, 0x03AB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03AC, 0x03B0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03B1, 0x03C1, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03C2, 0x03C2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03C3, 0x03C9, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03CA, 0x03CE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03D0, 0x03D1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03D2, 0x03D4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03D5, 0x03D7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03D8, 0x03D8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03D9, 0x03D9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03DA, 0x03DA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03DB, 0x03DB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03DC, 0x03DC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03DD, 0x03DD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03DE, 0x03DE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03DF, 0x03DF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03E0, 0x03E0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03E1, 0x03E1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03E2, 0x03E2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03E3, 0x03E3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03E4, 0x03E4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03E5, 0x03E5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03E6, 0x03E6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03E7, 0x03E7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03E8, 0x03E8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03E9, 0x03E9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03EA, 0x03EA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03EB, 0x03EB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03EC, 0x03EC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03ED, 0x03ED, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03EE, 0x03EE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03EF, 0x03F3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03F4, 0x03F4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03F5, 0x03F5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03F6, 0x03F6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03F7, 0x03F7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03F8, 0x03F8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03F9, 0x03FA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03FB, 0x03FC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x03FD, 0x0400, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0401, 0x0401, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0402, 0x040F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0410, 0x042F, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0430, 0x044F, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0450, 0x0450, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0451, 0x0451, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0452, 0x045F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0460, 0x0460, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0461, 0x0461, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0462, 0x0462, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0463, 0x0463, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0464, 0x0464, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0465, 0x0465, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0466, 0x0466, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0467, 0x0467, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			return i;
		}

		private int initialize2 (int i) {
			mRanges[i++] = new CharPropRange (0x0468, 0x0468, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0469, 0x0469, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x046A, 0x046A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x046B, 0x046B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x046C, 0x046C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x046D, 0x046D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x046E, 0x046E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x046F, 0x046F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0470, 0x0470, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0471, 0x0471, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0472, 0x0472, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0473, 0x0473, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0474, 0x0474, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0475, 0x0475, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0476, 0x0476, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0477, 0x0477, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0478, 0x0478, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0479, 0x0479, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x047A, 0x047A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x047B, 0x047B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x047C, 0x047C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x047D, 0x047D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x047E, 0x047E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x047F, 0x047F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0480, 0x0480, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0481, 0x0481, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0482, 0x0482, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0483, 0x0486, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0488, 0x0489, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x048A, 0x048A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x048B, 0x048B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x048C, 0x048C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x048D, 0x048D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x048E, 0x048E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x048F, 0x048F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0490, 0x0490, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0491, 0x0491, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0492, 0x0492, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0493, 0x0493, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0494, 0x0494, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0495, 0x0495, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0496, 0x0496, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0497, 0x0497, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0498, 0x0498, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0499, 0x0499, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x049A, 0x049A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x049B, 0x049B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x049C, 0x049C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x049D, 0x049D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x049E, 0x049E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x049F, 0x049F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04A0, 0x04A0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04A1, 0x04A1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04A2, 0x04A2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04A3, 0x04A3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04A4, 0x04A4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04A5, 0x04A5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04A6, 0x04A6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04A7, 0x04A7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04A8, 0x04A8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04A9, 0x04A9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04AA, 0x04AA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04AB, 0x04AB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04AC, 0x04AC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04AD, 0x04AD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04AE, 0x04AE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04AF, 0x04AF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04B0, 0x04B0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04B1, 0x04B1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04B2, 0x04B2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04B3, 0x04B3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04B4, 0x04B4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04B5, 0x04B5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04B6, 0x04B6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04B7, 0x04B7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04B8, 0x04B8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04B9, 0x04B9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04BA, 0x04BA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04BB, 0x04BB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04BC, 0x04BC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04BD, 0x04BD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04BE, 0x04BE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04BF, 0x04BF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04C0, 0x04C1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04C2, 0x04C2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04C3, 0x04C3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04C4, 0x04C4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04C5, 0x04C5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04C6, 0x04C6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04C7, 0x04C7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04C8, 0x04C8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04C9, 0x04C9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04CA, 0x04CA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04CB, 0x04CB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04CC, 0x04CC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04CD, 0x04CD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04CE, 0x04CE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04CF, 0x04CF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04D0, 0x04D0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04D1, 0x04D1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04D2, 0x04D2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04D3, 0x04D3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04D4, 0x04D4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04D5, 0x04D5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04D6, 0x04D6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04D7, 0x04D7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04D8, 0x04D8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04D9, 0x04D9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04DA, 0x04DA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04DB, 0x04DB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04DC, 0x04DC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04DD, 0x04DD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04DE, 0x04DE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04DF, 0x04DF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04E0, 0x04E0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04E1, 0x04E1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04E2, 0x04E2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04E3, 0x04E3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04E4, 0x04E4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04E5, 0x04E5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04E6, 0x04E6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04E7, 0x04E7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04E8, 0x04E8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04E9, 0x04E9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04EA, 0x04EA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04EB, 0x04EB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04EC, 0x04EC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04ED, 0x04ED, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04EE, 0x04EE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04EF, 0x04EF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04F0, 0x04F0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04F1, 0x04F1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04F2, 0x04F2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04F3, 0x04F3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04F4, 0x04F4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04F5, 0x04F5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04F6, 0x04F6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04F7, 0x04F7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04F8, 0x04F8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04F9, 0x04F9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04FA, 0x04FA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04FB, 0x04FB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04FC, 0x04FC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04FD, 0x04FD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04FE, 0x04FE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x04FF, 0x04FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0500, 0x0500, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0501, 0x0501, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0502, 0x0502, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0503, 0x0503, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0504, 0x0504, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0505, 0x0505, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0506, 0x0506, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0507, 0x0507, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0508, 0x0508, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0509, 0x0509, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x050A, 0x050A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x050B, 0x050B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x050C, 0x050C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x050D, 0x050D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x050E, 0x050E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x050F, 0x050F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0510, 0x0510, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0511, 0x0511, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0512, 0x0512, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0513, 0x0513, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0531, 0x0556, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0559, 0x0559, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x055A, 0x055F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0561, 0x0587, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0589, 0x0589, makeData (BREAK_IS, WIDTH_N, GRAPHEME_Default, WORD_MidNum, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x058A, 0x058A, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0590, 0x0590, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0591, 0x05B9, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05BA, 0x05BA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05BB, 0x05BD, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05BE, 0x05BE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05BF, 0x05BF, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05C0, 0x05C0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05C1, 0x05C2, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05C3, 0x05C3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05C4, 0x05C5, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05C6, 0x05C6, makeData (BREAK_EX, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05C7, 0x05C7, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05C8, 0x05CF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05D0, 0x05EA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05EB, 0x05EF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05F0, 0x05F3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05F4, 0x05F4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_MidLetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x05F5, 0x05FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0600, 0x0603, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0604, 0x060A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x060B, 0x060B, makeData (BREAK_PO, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x060C, 0x060C, makeData (BREAK_EX, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x060D, 0x060D, makeData (BREAK_IS, WIDTH_N, GRAPHEME_Default, WORD_MidNum, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x060E, 0x060F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0610, 0x0615, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0616, 0x061A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x061B, 0x061B, makeData (BREAK_EX, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x061C, 0x061D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x061E, 0x061F, makeData (BREAK_EX, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0620, 0x0620, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0621, 0x063A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x063B, 0x063F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0640, 0x064A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x064B, 0x065E, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x065F, 0x065F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0660, 0x0669, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_AN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x066A, 0x066A, makeData (BREAK_EX, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x066B, 0x066C, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_AN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x066D, 0x066D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x066E, 0x066F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0670, 0x0670, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0671, 0x06D3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06D4, 0x06D4, makeData (BREAK_EX, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06D5, 0x06D5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06D6, 0x06DC, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06DD, 0x06DD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06DE, 0x06E4, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06E5, 0x06E6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06E7, 0x06E8, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06E9, 0x06E9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06EA, 0x06ED, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06EE, 0x06EF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06F0, 0x06F9, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06FA, 0x06FC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06FD, 0x06FE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x06FF, 0x06FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0700, 0x070E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x070F, 0x070F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0710, 0x0710, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0711, 0x0711, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0712, 0x072F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0730, 0x074A, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x074B, 0x074C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x074D, 0x076D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x076E, 0x077F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0780, 0x07A5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x07A6, 0x07B0, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x07B1, 0x07B1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x07B2, 0x07BF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x07C0, 0x07EA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x07EB, 0x07F3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x07F4, 0x07F5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x07F6, 0x07F9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x07FA, 0x08FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0901, 0x0902, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0903, 0x0903, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0904, 0x0939, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x093C, 0x093C, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x093D, 0x093D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x093E, 0x0940, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0941, 0x0948, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0949, 0x094C, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x094D, 0x094D, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0950, 0x0950, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0951, 0x0954, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0958, 0x0961, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0962, 0x0963, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0964, 0x0965, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0966, 0x096F, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0970, 0x0970, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x097B, 0x097C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x097D, 0x097D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x097E, 0x097F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0981, 0x0981, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0982, 0x0983, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0985, 0x098C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x098F, 0x0990, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0993, 0x09A8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09AA, 0x09B0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09B2, 0x09B2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09B6, 0x09B9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09BC, 0x09BC, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09BD, 0x09BD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09BE, 0x09BE, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09BF, 0x09C0, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09C1, 0x09C4, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09C7, 0x09C8, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09CB, 0x09CC, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09CD, 0x09CD, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09CE, 0x09CE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09D7, 0x09D7, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09DC, 0x09DD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09DF, 0x09E1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09E2, 0x09E3, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09E6, 0x09EF, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09F0, 0x09F1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09F2, 0x09F3, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x09F4, 0x09FA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A01, 0x0A02, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A03, 0x0A03, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A05, 0x0A0A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A0F, 0x0A10, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A13, 0x0A28, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A2A, 0x0A30, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A32, 0x0A33, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A35, 0x0A36, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A38, 0x0A39, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A3C, 0x0A3C, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A3E, 0x0A40, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A41, 0x0A42, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A47, 0x0A48, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A4B, 0x0A4D, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A59, 0x0A5C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A5E, 0x0A5E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A66, 0x0A6F, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A70, 0x0A71, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A72, 0x0A74, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A81, 0x0A82, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A83, 0x0A83, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A85, 0x0A8D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A8F, 0x0A91, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0A93, 0x0AA8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AAA, 0x0AB0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AB2, 0x0AB3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AB5, 0x0AB9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0ABC, 0x0ABC, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0ABD, 0x0ABD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0ABE, 0x0AC0, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AC1, 0x0AC5, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AC7, 0x0AC8, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AC9, 0x0AC9, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0ACB, 0x0ACC, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0ACD, 0x0ACD, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AD0, 0x0AD0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AE0, 0x0AE1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AE2, 0x0AE3, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AE6, 0x0AEF, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0AF1, 0x0AF1, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B01, 0x0B01, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B02, 0x0B03, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B05, 0x0B0C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B0F, 0x0B10, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B13, 0x0B28, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B2A, 0x0B30, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B32, 0x0B33, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B35, 0x0B39, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B3C, 0x0B3C, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B3D, 0x0B3D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B3E, 0x0B3E, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B3F, 0x0B3F, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B40, 0x0B40, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B41, 0x0B43, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B47, 0x0B48, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B4B, 0x0B4C, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B4D, 0x0B4D, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B56, 0x0B56, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B57, 0x0B57, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B5C, 0x0B5D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B5F, 0x0B61, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B66, 0x0B6F, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B70, 0x0B70, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B71, 0x0B71, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B82, 0x0B82, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B83, 0x0B83, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B85, 0x0B8A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B8E, 0x0B90, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B92, 0x0B95, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B99, 0x0B9A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B9C, 0x0B9C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0B9E, 0x0B9F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BA3, 0x0BA4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BA8, 0x0BAA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BAE, 0x0BB9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BBE, 0x0BBE, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BBF, 0x0BBF, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BC0, 0x0BC0, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BC1, 0x0BC2, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BC6, 0x0BC8, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BCA, 0x0BCC, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BCD, 0x0BCD, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BD7, 0x0BD7, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BE6, 0x0BEF, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BF0, 0x0BF2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BF3, 0x0BF8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BF9, 0x0BF9, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0BFA, 0x0BFA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C01, 0x0C03, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C05, 0x0C0C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C0E, 0x0C10, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C12, 0x0C28, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C2A, 0x0C33, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C35, 0x0C39, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C3E, 0x0C40, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C41, 0x0C44, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C46, 0x0C48, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C4A, 0x0C4D, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C55, 0x0C56, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C60, 0x0C61, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C66, 0x0C6F, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C82, 0x0C83, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C85, 0x0C8C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C8E, 0x0C90, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0C92, 0x0CA8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CAA, 0x0CB3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CB5, 0x0CB9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CBC, 0x0CBC, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CBD, 0x0CBD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CBE, 0x0CBE, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CBF, 0x0CBF, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CC0, 0x0CC1, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CC2, 0x0CC2, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CC3, 0x0CC4, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CC6, 0x0CC6, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CC7, 0x0CC8, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CCA, 0x0CCB, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CCC, 0x0CCD, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CD5, 0x0CD6, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CDE, 0x0CDE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CE0, 0x0CE1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CE2, 0x0CE3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CE6, 0x0CEF, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0CF1, 0x0CF2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D02, 0x0D03, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D05, 0x0D0C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D0E, 0x0D10, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D12, 0x0D28, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D2A, 0x0D39, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D3E, 0x0D3E, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D3F, 0x0D40, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D41, 0x0D43, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D46, 0x0D48, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D4A, 0x0D4C, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D4D, 0x0D4D, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D57, 0x0D57, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D60, 0x0D61, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D66, 0x0D6F, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D82, 0x0D83, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D85, 0x0D96, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0D9A, 0x0DB1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DB3, 0x0DBB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DBD, 0x0DBD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DC0, 0x0DC6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DCA, 0x0DCA, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DCF, 0x0DCF, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DD0, 0x0DD1, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DD2, 0x0DD4, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DD6, 0x0DD6, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DD8, 0x0DDE, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DDF, 0x0DDF, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DF2, 0x0DF3, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0DF4, 0x0DF4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E01, 0x0E30, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E31, 0x0E31, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E32, 0x0E33, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E34, 0x0E3A, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E3F, 0x0E3F, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E40, 0x0E46, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E47, 0x0E4E, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E4F, 0x0E4F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E50, 0x0E59, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E5A, 0x0E5B, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E81, 0x0E82, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E84, 0x0E84, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E87, 0x0E88, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E8A, 0x0E8A, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E8D, 0x0E8D, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E94, 0x0E97, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0E99, 0x0E9F, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EA1, 0x0EA3, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EA5, 0x0EA5, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EA7, 0x0EA7, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EAA, 0x0EAB, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EAD, 0x0EB0, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EB1, 0x0EB1, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EB2, 0x0EB3, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EB4, 0x0EB9, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EBB, 0x0EBC, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EBD, 0x0EBD, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EC0, 0x0EC4, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EC6, 0x0EC6, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EC8, 0x0ECD, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0ED0, 0x0ED9, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0EDC, 0x0EDD, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F00, 0x0F00, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F01, 0x0F04, makeData (BREAK_BB, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F05, 0x0F05, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F06, 0x0F07, makeData (BREAK_BB, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F08, 0x0F08, makeData (BREAK_GL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F09, 0x0F0A, makeData (BREAK_BB, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F0B, 0x0F0B, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F0C, 0x0F0C, makeData (BREAK_GL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F0D, 0x0F11, makeData (BREAK_EX, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F12, 0x0F12, makeData (BREAK_GL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F13, 0x0F13, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F14, 0x0F14, makeData (BREAK_EX, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F15, 0x0F17, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F18, 0x0F19, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F1A, 0x0F1F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F20, 0x0F29, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F2A, 0x0F33, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F34, 0x0F34, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F35, 0x0F35, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F36, 0x0F36, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F37, 0x0F37, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F38, 0x0F38, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F39, 0x0F39, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F3A, 0x0F3A, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x0F3B, 0x0F3B, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x0F3C, 0x0F3C, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			return i;
		}

		private int initialize3 (int i) {
			mRanges[i++] = new CharPropRange (0x0F3D, 0x0F3D, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x0F3E, 0x0F3F, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F40, 0x0F47, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F49, 0x0F6A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F71, 0x0F7E, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F7F, 0x0F7F, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F80, 0x0F84, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F85, 0x0F85, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F86, 0x0F87, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F88, 0x0F8B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F90, 0x0F97, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0F99, 0x0FBC, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0FBE, 0x0FBF, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0FC0, 0x0FC5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0FC6, 0x0FC6, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0FC7, 0x0FCC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0FCF, 0x0FCF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x0FD0, 0x0FD1, makeData (BREAK_BB, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1000, 0x1021, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1023, 0x1027, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1029, 0x102A, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x102C, 0x102C, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x102D, 0x1030, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1031, 0x1031, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1032, 0x1032, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1036, 0x1037, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1038, 0x1038, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1039, 0x1039, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1040, 0x1049, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x104A, 0x104B, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x104C, 0x104F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1050, 0x1055, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1056, 0x1057, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1058, 0x1059, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A0, 0x10C5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10D0, 0x10FA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10FB, 0x10FB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10FC, 0x10FC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1100, 0x1159, makeData (BREAK_JL, WIDTH_W, GRAPHEME_L, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x115F, 0x115F, makeData (BREAK_JL, WIDTH_W, GRAPHEME_L, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1160, 0x11A2, makeData (BREAK_JV, WIDTH_N, GRAPHEME_V, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x11A8, 0x11F9, makeData (BREAK_JT, WIDTH_N, GRAPHEME_T, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1200, 0x1248, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x124A, 0x124D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1250, 0x1256, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1258, 0x1258, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x125A, 0x125D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1260, 0x1288, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x128A, 0x128D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1290, 0x12B0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x12B2, 0x12B5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x12B8, 0x12BE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x12C0, 0x12C0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x12C2, 0x12C5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x12C8, 0x12D6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x12D8, 0x1310, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1312, 0x1315, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1318, 0x135A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x135F, 0x135F, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1360, 0x1360, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1361, 0x1361, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1362, 0x137C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1380, 0x138F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1390, 0x1399, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x13A0, 0x13F4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1401, 0x166C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x166D, 0x166E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x166F, 0x1676, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1680, 0x1680, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_WS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1681, 0x169A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x169B, 0x169B, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x169C, 0x169C, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x16A0, 0x16EA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x16EB, 0x16ED, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x16EE, 0x16F0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1700, 0x170C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x170E, 0x1711, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1712, 0x1714, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1720, 0x1731, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1732, 0x1734, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1735, 0x1736, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1740, 0x1751, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1752, 0x1753, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1760, 0x176C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x176E, 0x1770, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1772, 0x1773, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1780, 0x17B3, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17B4, 0x17B5, makeData (BREAK_SA, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17B6, 0x17B6, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17B7, 0x17BD, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17BE, 0x17C5, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17C6, 0x17C6, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17C7, 0x17C8, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17C9, 0x17D3, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17D4, 0x17D5, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17D6, 0x17D6, makeData (BREAK_NS, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17D7, 0x17D7, makeData (BREAK_NS, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17D8, 0x17D8, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17D9, 0x17D9, makeData (BREAK_NS, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17DA, 0x17DA, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17DB, 0x17DB, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17DC, 0x17DC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17DD, 0x17DD, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17E0, 0x17E9, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x17F0, 0x17F9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1800, 0x1801, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1802, 0x1805, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1806, 0x1806, makeData (BREAK_BB, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1807, 0x1807, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1808, 0x1809, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x180A, 0x180A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x180B, 0x180D, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x180E, 0x180E, makeData (BREAK_GL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_WS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1810, 0x1819, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1820, 0x1877, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1880, 0x18A8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x18A9, 0x18A9, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1900, 0x191C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1920, 0x1922, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1923, 0x1926, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1927, 0x1928, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1929, 0x192B, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1930, 0x1931, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1932, 0x1932, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1933, 0x1938, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1939, 0x193B, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1940, 0x1940, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1944, 0x1945, makeData (BREAK_EX, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1946, 0x194F, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1950, 0x196D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1970, 0x1974, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1980, 0x19A9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x19B0, 0x19C0, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x19C1, 0x19C7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x19C8, 0x19C9, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x19D0, 0x19D9, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x19DE, 0x19FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1A00, 0x1A16, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1A17, 0x1A18, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1A19, 0x1A1B, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1A1E, 0x1A1E, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1A1F, 0x1A1F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B00, 0x1B03, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B04, 0x1B33, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B34, 0x1B34, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B35, 0x1B35, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B36, 0x1B3A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B3B, 0x1B3B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B3C, 0x1B3C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B3D, 0x1B41, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B42, 0x1B42, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B43, 0x1B4B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B50, 0x1B6A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B6B, 0x1B73, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1B74, 0x1B7C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D00, 0x1DBF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1DC0, 0x1DC3, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1DC4, 0x1DCA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1DFE, 0x1DFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E00, 0x1E00, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E01, 0x1E01, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E02, 0x1E02, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E03, 0x1E03, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E04, 0x1E04, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E05, 0x1E05, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E06, 0x1E06, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E07, 0x1E07, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E08, 0x1E08, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E09, 0x1E09, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E0A, 0x1E0A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E0B, 0x1E0B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E0C, 0x1E0C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E0D, 0x1E0D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E0E, 0x1E0E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E0F, 0x1E0F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E10, 0x1E10, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E11, 0x1E11, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E12, 0x1E12, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E13, 0x1E13, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E14, 0x1E14, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E15, 0x1E15, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E16, 0x1E16, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E17, 0x1E17, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E18, 0x1E18, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E19, 0x1E19, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E1A, 0x1E1A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E1B, 0x1E1B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E1C, 0x1E1C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E1D, 0x1E1D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E1E, 0x1E1E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E1F, 0x1E1F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E20, 0x1E20, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E21, 0x1E21, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E22, 0x1E22, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E23, 0x1E23, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E24, 0x1E24, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E25, 0x1E25, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E26, 0x1E26, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E27, 0x1E27, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E28, 0x1E28, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E29, 0x1E29, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E2A, 0x1E2A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E2B, 0x1E2B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E2C, 0x1E2C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E2D, 0x1E2D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E2E, 0x1E2E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E2F, 0x1E2F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E30, 0x1E30, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E31, 0x1E31, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E32, 0x1E32, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E33, 0x1E33, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E34, 0x1E34, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E35, 0x1E35, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E36, 0x1E36, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E37, 0x1E37, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E38, 0x1E38, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E39, 0x1E39, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E3A, 0x1E3A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E3B, 0x1E3B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E3C, 0x1E3C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E3D, 0x1E3D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E3E, 0x1E3E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E3F, 0x1E3F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E40, 0x1E40, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E41, 0x1E41, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E42, 0x1E42, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E43, 0x1E43, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E44, 0x1E44, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E45, 0x1E45, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E46, 0x1E46, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E47, 0x1E47, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E48, 0x1E48, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E49, 0x1E49, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E4A, 0x1E4A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E4B, 0x1E4B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E4C, 0x1E4C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E4D, 0x1E4D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E4E, 0x1E4E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E4F, 0x1E4F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E50, 0x1E50, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E51, 0x1E51, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E52, 0x1E52, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E53, 0x1E53, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E54, 0x1E54, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E55, 0x1E55, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E56, 0x1E56, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E57, 0x1E57, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E58, 0x1E58, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E59, 0x1E59, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E5A, 0x1E5A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E5B, 0x1E5B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E5C, 0x1E5C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E5D, 0x1E5D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E5E, 0x1E5E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E5F, 0x1E5F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E60, 0x1E60, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E61, 0x1E61, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E62, 0x1E62, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E63, 0x1E63, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E64, 0x1E64, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E65, 0x1E65, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E66, 0x1E66, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E67, 0x1E67, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E68, 0x1E68, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E69, 0x1E69, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E6A, 0x1E6A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E6B, 0x1E6B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E6C, 0x1E6C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E6D, 0x1E6D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E6E, 0x1E6E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E6F, 0x1E6F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E70, 0x1E70, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E71, 0x1E71, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E72, 0x1E72, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E73, 0x1E73, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E74, 0x1E74, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E75, 0x1E75, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E76, 0x1E76, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E77, 0x1E77, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E78, 0x1E78, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E79, 0x1E79, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E7A, 0x1E7A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E7B, 0x1E7B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E7C, 0x1E7C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E7D, 0x1E7D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E7E, 0x1E7E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E7F, 0x1E7F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E80, 0x1E80, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E81, 0x1E81, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E82, 0x1E82, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E83, 0x1E83, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E84, 0x1E84, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E85, 0x1E85, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E86, 0x1E86, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E87, 0x1E87, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E88, 0x1E88, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E89, 0x1E89, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E8A, 0x1E8A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E8B, 0x1E8B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E8C, 0x1E8C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E8D, 0x1E8D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E8E, 0x1E8E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E8F, 0x1E8F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E90, 0x1E90, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E91, 0x1E91, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E92, 0x1E92, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E93, 0x1E93, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E94, 0x1E94, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1E95, 0x1E9B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EA0, 0x1EA0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EA1, 0x1EA1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EA2, 0x1EA2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EA3, 0x1EA3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EA4, 0x1EA4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EA5, 0x1EA5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EA6, 0x1EA6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EA7, 0x1EA7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EA8, 0x1EA8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EA9, 0x1EA9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EAA, 0x1EAA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EAB, 0x1EAB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EAC, 0x1EAC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EAD, 0x1EAD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EAE, 0x1EAE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EAF, 0x1EAF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EB0, 0x1EB0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EB1, 0x1EB1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EB2, 0x1EB2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EB3, 0x1EB3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EB4, 0x1EB4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EB5, 0x1EB5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EB6, 0x1EB6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EB7, 0x1EB7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EB8, 0x1EB8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EB9, 0x1EB9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EBA, 0x1EBA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EBB, 0x1EBB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EBC, 0x1EBC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EBD, 0x1EBD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EBE, 0x1EBE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EBF, 0x1EBF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EC0, 0x1EC0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EC1, 0x1EC1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EC2, 0x1EC2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EC3, 0x1EC3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EC4, 0x1EC4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EC5, 0x1EC5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EC6, 0x1EC6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EC7, 0x1EC7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EC8, 0x1EC8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EC9, 0x1EC9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ECA, 0x1ECA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ECB, 0x1ECB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ECC, 0x1ECC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ECD, 0x1ECD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ECE, 0x1ECE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ECF, 0x1ECF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ED0, 0x1ED0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ED1, 0x1ED1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ED2, 0x1ED2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ED3, 0x1ED3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ED4, 0x1ED4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ED5, 0x1ED5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ED6, 0x1ED6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ED7, 0x1ED7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ED8, 0x1ED8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1ED9, 0x1ED9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EDA, 0x1EDA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EDB, 0x1EDB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EDC, 0x1EDC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EDD, 0x1EDD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EDE, 0x1EDE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EDF, 0x1EDF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EE0, 0x1EE0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EE1, 0x1EE1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EE2, 0x1EE2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EE3, 0x1EE3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EE4, 0x1EE4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EE5, 0x1EE5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EE6, 0x1EE6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EE7, 0x1EE7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EE8, 0x1EE8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EE9, 0x1EE9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EEA, 0x1EEA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EEB, 0x1EEB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EEC, 0x1EEC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EED, 0x1EED, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EEE, 0x1EEE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EEF, 0x1EEF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EF0, 0x1EF0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EF1, 0x1EF1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EF2, 0x1EF2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EF3, 0x1EF3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EF4, 0x1EF4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EF5, 0x1EF5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EF6, 0x1EF6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EF7, 0x1EF7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EF8, 0x1EF8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1EF9, 0x1EF9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F00, 0x1F07, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F08, 0x1F0F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F10, 0x1F15, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F18, 0x1F1D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F20, 0x1F27, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F28, 0x1F2F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F30, 0x1F37, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F38, 0x1F3F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F40, 0x1F45, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F48, 0x1F4D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F50, 0x1F57, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F59, 0x1F59, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F5B, 0x1F5B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F5D, 0x1F5D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F5F, 0x1F5F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F60, 0x1F67, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F68, 0x1F6F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F70, 0x1F7D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F80, 0x1F87, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F88, 0x1F8F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Titlecase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F90, 0x1F97, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1F98, 0x1F9F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Titlecase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FA0, 0x1FA7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FA8, 0x1FAF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Titlecase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FB0, 0x1FB4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FB6, 0x1FB7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FB8, 0x1FBB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FBC, 0x1FBC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Titlecase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FBD, 0x1FBD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FBE, 0x1FBE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FBF, 0x1FC1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FC2, 0x1FC4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FC6, 0x1FC7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FC8, 0x1FCB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FCC, 0x1FCC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Titlecase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FCD, 0x1FCF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FD0, 0x1FD3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FD6, 0x1FD7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FD8, 0x1FDB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FDD, 0x1FDF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FE0, 0x1FE7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FE8, 0x1FEC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FED, 0x1FEF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FF2, 0x1FF4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FF6, 0x1FF7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FF8, 0x1FFB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FFC, 0x1FFC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Titlecase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FFD, 0x1FFE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2000, 0x2006, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_WS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2007, 0x2007, makeData (BREAK_GL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_WS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2008, 0x200A, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_WS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x200B, 0x200B, makeData (BREAK_ZW, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x200C, 0x200D, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x200E, 0x200E, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x200F, 0x200F, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2010, 0x2010, makeData (BREAK_BA, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2011, 0x2011, makeData (BREAK_GL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2012, 0x2012, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2013, 0x2013, makeData (BREAK_BA, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2014, 0x2014, makeData (BREAK_B2, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2015, 0x2016, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2017, 0x2017, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2018, 0x2018, makeData (BREAK_QU, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2019, 0x2019, makeData (BREAK_QU, WIDTH_A, GRAPHEME_Default, WORD_MidLetter, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x201A, 0x201A, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x201B, 0x201B, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x201C, 0x201D, makeData (BREAK_QU, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x201E, 0x201E, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x201F, 0x201F, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2020, 0x2021, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2022, 0x2022, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2023, 0x2023, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2024, 0x2026, makeData (BREAK_IN, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2027, 0x2027, makeData (BREAK_BA, WIDTH_A, GRAPHEME_Default, WORD_MidLetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2028, 0x2028, makeData (BREAK_BK, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_WS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2029, 0x2029, makeData (BREAK_BK, WIDTH_N, GRAPHEME_Control, WORD_Default, CASE_Default, BIDI_B, BM_OFF));
			mRanges[i++] = new CharPropRange (0x202A, 0x202A, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_LRE, BM_OFF));
			mRanges[i++] = new CharPropRange (0x202B, 0x202B, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_RLE, BM_OFF));
			mRanges[i++] = new CharPropRange (0x202C, 0x202C, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_PDF, BM_OFF));
			mRanges[i++] = new CharPropRange (0x202D, 0x202D, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_LRO, BM_OFF));
			mRanges[i++] = new CharPropRange (0x202E, 0x202E, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_RLO, BM_OFF));
			mRanges[i++] = new CharPropRange (0x202F, 0x202F, makeData (BREAK_GL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2030, 0x2030, makeData (BREAK_PO, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2031, 0x2031, makeData (BREAK_PO, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2032, 0x2033, makeData (BREAK_PO, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2034, 0x2034, makeData (BREAK_PO, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2035, 0x2035, makeData (BREAK_PO, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2036, 0x2037, makeData (BREAK_PO, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2038, 0x2038, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2039, 0x203A, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x203B, 0x203B, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x203C, 0x203C, makeData (BREAK_NS, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x203D, 0x203D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x203E, 0x203E, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x203F, 0x2040, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ExtendNumLet, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2041, 0x2043, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2044, 0x2044, makeData (BREAK_IS, WIDTH_N, GRAPHEME_Default, WORD_MidNum, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2045, 0x2045, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2046, 0x2046, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2047, 0x2053, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2054, 0x2054, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ExtendNumLet, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2055, 0x2055, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			return i;
		}

		private int initialize4 (int i) {
			mRanges[i++] = new CharPropRange (0x2056, 0x2056, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2057, 0x2057, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2058, 0x205B, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x205C, 0x205C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x205D, 0x205E, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x205F, 0x205F, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_WS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2060, 0x2060, makeData (BREAK_WJ, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2061, 0x2063, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2064, 0x2069, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x206A, 0x206F, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2070, 0x2070, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2071, 0x2071, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2074, 0x2074, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2075, 0x2079, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x207A, 0x207B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ES, BM_OFF));
			mRanges[i++] = new CharPropRange (0x207C, 0x207C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x207D, 0x207D, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x207E, 0x207E, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x207F, 0x207F, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2080, 0x2080, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2081, 0x2084, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2085, 0x2089, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x208A, 0x208B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ES, BM_OFF));
			mRanges[i++] = new CharPropRange (0x208C, 0x208C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x208D, 0x208D, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x208E, 0x208E, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2090, 0x2094, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x20A0, 0x20A6, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x20A7, 0x20A7, makeData (BREAK_PO, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x20A8, 0x20A8, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x20A9, 0x20A9, makeData (BREAK_PR, WIDTH_H, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x20AA, 0x20AB, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x20AC, 0x20AC, makeData (BREAK_PR, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x20AD, 0x20B5, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x20D0, 0x20EB, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x20EC, 0x20EF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2100, 0x2101, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2102, 0x2102, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2103, 0x2103, makeData (BREAK_PO, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2104, 0x2104, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2105, 0x2105, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2106, 0x2106, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2107, 0x2107, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2108, 0x2108, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2109, 0x2109, makeData (BREAK_PO, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x210A, 0x210A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x210B, 0x210D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x210E, 0x210F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2110, 0x2112, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2113, 0x2113, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2114, 0x2114, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2115, 0x2115, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2116, 0x2116, makeData (BREAK_PR, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2117, 0x2118, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2119, 0x211D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x211E, 0x2120, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2121, 0x2122, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2123, 0x2123, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2124, 0x2124, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2125, 0x2125, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2126, 0x2126, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2127, 0x2127, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2128, 0x2128, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2129, 0x2129, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x212A, 0x212A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x212B, 0x212B, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x212C, 0x212D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x212E, 0x212E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x212F, 0x212F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2130, 0x2131, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2132, 0x2132, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2133, 0x2133, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2134, 0x2134, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2135, 0x2138, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2139, 0x2139, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x213A, 0x213B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x213C, 0x213D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x213E, 0x213F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2140, 0x2144, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2145, 0x2145, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2146, 0x2149, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x214A, 0x214D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x214E, 0x214E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2153, 0x2153, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2154, 0x2154, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2155, 0x2155, makeData (BREAK_AI, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2156, 0x215A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x215B, 0x215B, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x215C, 0x215D, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x215E, 0x215E, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x215F, 0x215F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2160, 0x216B, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x216C, 0x216F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2170, 0x2179, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x217A, 0x217F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2180, 0x2182, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2183, 0x2183, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2184, 0x2184, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2190, 0x2199, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x219A, 0x21B7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x21B8, 0x21B9, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x21BA, 0x21D1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x21D2, 0x21D2, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x21D3, 0x21D3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x21D4, 0x21D4, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x21D5, 0x21E6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x21E7, 0x21E7, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x21E8, 0x21FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2200, 0x2200, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2201, 0x2201, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2202, 0x2203, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2204, 0x2206, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2207, 0x2207, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2208, 0x2208, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2209, 0x220A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x220B, 0x220B, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x220C, 0x220D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x220E, 0x220E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x220F, 0x220F, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2210, 0x2210, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2211, 0x2211, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2212, 0x2212, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ES, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2213, 0x2213, makeData (BREAK_PR, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2214, 0x2214, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2215, 0x2215, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2216, 0x2219, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x221A, 0x221A, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x221B, 0x221C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x221D, 0x2220, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2221, 0x2222, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2223, 0x2223, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2224, 0x2224, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2225, 0x2225, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2226, 0x2226, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2227, 0x222C, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x222D, 0x222D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x222E, 0x222E, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x222F, 0x2233, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2234, 0x2237, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2238, 0x223B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x223C, 0x223D, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x223E, 0x2242, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2243, 0x2243, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2244, 0x2247, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2248, 0x2248, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2249, 0x224B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x224C, 0x224C, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x224D, 0x2251, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2252, 0x2252, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2253, 0x2255, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2256, 0x225F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2260, 0x2261, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2262, 0x2263, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2264, 0x2267, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2268, 0x2269, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x226A, 0x226B, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x226C, 0x226D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x226E, 0x226F, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2270, 0x2281, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2282, 0x2283, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2284, 0x2285, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2286, 0x2287, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2288, 0x228B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x228C, 0x228E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x228F, 0x2292, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2293, 0x2294, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2295, 0x2295, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2296, 0x2297, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2298, 0x2298, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2299, 0x2299, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x229A, 0x22A1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22A2, 0x22A3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22A4, 0x22A4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22A5, 0x22A5, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22A6, 0x22A6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22A7, 0x22A7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22A8, 0x22A9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22AA, 0x22AA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22AB, 0x22AB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22AC, 0x22AF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22B0, 0x22B7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22B8, 0x22BE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22BF, 0x22BF, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22C0, 0x22C8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22C9, 0x22CD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22CE, 0x22CF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22D0, 0x22D1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22D2, 0x22D5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22D6, 0x22ED, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22EE, 0x22EF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22F0, 0x22F4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22F5, 0x22F5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22F6, 0x22F7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22F8, 0x22F9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x22FA, 0x22FE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x22FF, 0x2307, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2308, 0x230B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x230C, 0x2311, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2312, 0x2312, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2313, 0x2328, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2329, 0x2329, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x232A, 0x232A, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x232B, 0x2335, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2336, 0x237A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x237B, 0x2394, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2395, 0x2395, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2396, 0x23B3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x23B4, 0x23B4, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x23B5, 0x23B5, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x23B6, 0x23B6, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x23B7, 0x23E7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2400, 0x2426, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2440, 0x244A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2460, 0x2487, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2488, 0x249B, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x249C, 0x24B5, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x24B6, 0x24CF, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x24D0, 0x24E9, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x24EA, 0x24EA, makeData (BREAK_AI, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x24EB, 0x24FE, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x24FF, 0x24FF, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2500, 0x254B, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x254C, 0x254F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2550, 0x2573, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2574, 0x2574, makeData (BREAK_AI, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2575, 0x257F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2580, 0x258F, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2590, 0x2591, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2592, 0x2595, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2596, 0x259F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25A0, 0x25A1, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25A2, 0x25A2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25A3, 0x25A9, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25AA, 0x25B1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25B2, 0x25B3, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25B4, 0x25B5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25B6, 0x25B7, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25B8, 0x25BB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25BC, 0x25BD, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25BE, 0x25BF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25C0, 0x25C1, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25C2, 0x25C5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25C6, 0x25C8, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25C9, 0x25CA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25CB, 0x25CB, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25CC, 0x25CD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25CE, 0x25D1, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25D2, 0x25E1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25E2, 0x25E5, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25E6, 0x25EE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25EF, 0x25EF, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x25F0, 0x2604, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2605, 0x2606, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2607, 0x2608, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2609, 0x2609, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x260A, 0x260D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x260E, 0x260F, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2610, 0x2613, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2614, 0x2615, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2616, 0x2617, makeData (BREAK_AI, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2618, 0x261B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x261C, 0x261C, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x261D, 0x261D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x261E, 0x261E, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x261F, 0x263F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2640, 0x2640, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2641, 0x2641, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2642, 0x2642, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2643, 0x265F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2660, 0x2661, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2662, 0x2662, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2663, 0x2665, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2666, 0x2666, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2667, 0x266A, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x266B, 0x266B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x266C, 0x266D, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x266E, 0x266E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x266F, 0x266F, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2670, 0x269C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x26A0, 0x26AB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x26AC, 0x26AC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x26AD, 0x26B2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2701, 0x2704, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2706, 0x2709, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x270C, 0x2727, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2729, 0x273C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x273D, 0x273D, makeData (BREAK_AL, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x273E, 0x274B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x274D, 0x274D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x274F, 0x2752, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2756, 0x2756, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2758, 0x275A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x275B, 0x275E, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2761, 0x2761, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2762, 0x2763, makeData (BREAK_EX, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2764, 0x2767, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2768, 0x2768, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2769, 0x2769, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x276A, 0x276A, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x276B, 0x276B, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x276C, 0x276C, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x276D, 0x276D, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x276E, 0x276E, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x276F, 0x276F, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2770, 0x2770, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2771, 0x2771, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2772, 0x2772, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2773, 0x2773, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2774, 0x2774, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2775, 0x2775, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2776, 0x277F, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2780, 0x2793, makeData (BREAK_AI, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2794, 0x2794, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2798, 0x27AF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x27B1, 0x27BE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x27C0, 0x27C2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x27C3, 0x27C4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27C5, 0x27C5, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27C6, 0x27C6, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27C7, 0x27CA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x27D0, 0x27D4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x27D5, 0x27D6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27D7, 0x27DC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x27DD, 0x27DE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27DF, 0x27E1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x27E2, 0x27E5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27E6, 0x27E6, makeData (BREAK_OP, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27E7, 0x27E7, makeData (BREAK_CL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27E8, 0x27E8, makeData (BREAK_OP, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27E9, 0x27E9, makeData (BREAK_CL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27EA, 0x27EA, makeData (BREAK_OP, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27EB, 0x27EB, makeData (BREAK_CL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x27F0, 0x27FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2800, 0x28FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2900, 0x2982, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2983, 0x2983, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2984, 0x2984, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2985, 0x2985, makeData (BREAK_OP, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2986, 0x2986, makeData (BREAK_CL, WIDTH_Na, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2987, 0x2987, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2988, 0x2988, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2989, 0x2989, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x298A, 0x298A, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x298B, 0x298B, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x298C, 0x298C, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x298D, 0x298D, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x298E, 0x298E, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x298F, 0x298F, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2990, 0x2990, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2991, 0x2991, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2992, 0x2992, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2993, 0x2993, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2994, 0x2994, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2995, 0x2995, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2996, 0x2996, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2997, 0x2997, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2998, 0x2998, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2999, 0x29B7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x29B8, 0x29B8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29B9, 0x29BF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x29C0, 0x29C1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29C2, 0x29C3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x29C4, 0x29C5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29C6, 0x29CE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x29CF, 0x29D2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29D3, 0x29D3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x29D4, 0x29D5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29D6, 0x29D7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x29D8, 0x29D8, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29D9, 0x29D9, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29DA, 0x29DA, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29DB, 0x29DB, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29DC, 0x29F4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x29F5, 0x29F5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29F6, 0x29F7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x29F8, 0x29F9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29FA, 0x29FB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x29FC, 0x29FC, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29FD, 0x29FD, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x29FE, 0x2A2A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2A2B, 0x2A2E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2A2F, 0x2A33, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2A34, 0x2A35, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2A36, 0x2A3B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2A3C, 0x2A3D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2A3E, 0x2A63, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2A64, 0x2A65, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2A66, 0x2A78, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2A79, 0x2A7A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2A7B, 0x2A7C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2A7D, 0x2A84, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2A85, 0x2A8A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2A8B, 0x2A8C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2A8D, 0x2A90, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2A91, 0x2A9C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2A9D, 0x2AA0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2AA1, 0x2AA2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2AA3, 0x2AA5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2AA6, 0x2AAD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2AAE, 0x2AAE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2AAF, 0x2AB0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2AB1, 0x2AB2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2AB3, 0x2AB4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2AB5, 0x2ABA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2ABB, 0x2AC6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2AC7, 0x2ACC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2ACD, 0x2AD6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2AD7, 0x2ADD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2ADE, 0x2ADE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2ADF, 0x2AE2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2AE3, 0x2AE5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2AE6, 0x2AEB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2AEC, 0x2AED, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2AEE, 0x2AF6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2AF7, 0x2AFA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2AFB, 0x2B1A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2B20, 0x2B23, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C00, 0x2C2E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C30, 0x2C5E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C60, 0x2C60, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C61, 0x2C61, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C62, 0x2C64, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C65, 0x2C66, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C67, 0x2C67, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C68, 0x2C68, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C69, 0x2C69, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C6A, 0x2C6A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C6B, 0x2C6B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C6C, 0x2C6C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C74, 0x2C74, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C75, 0x2C75, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C76, 0x2C77, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C80, 0x2C80, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C81, 0x2C81, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C82, 0x2C82, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C83, 0x2C83, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C84, 0x2C84, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C85, 0x2C85, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C86, 0x2C86, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C87, 0x2C87, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C88, 0x2C88, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C89, 0x2C89, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C8A, 0x2C8A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C8B, 0x2C8B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C8C, 0x2C8C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C8D, 0x2C8D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C8E, 0x2C8E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C8F, 0x2C8F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C90, 0x2C90, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C91, 0x2C91, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C92, 0x2C92, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C93, 0x2C93, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C94, 0x2C94, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C95, 0x2C95, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C96, 0x2C96, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C97, 0x2C97, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C98, 0x2C98, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C99, 0x2C99, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C9A, 0x2C9A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C9B, 0x2C9B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C9C, 0x2C9C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C9D, 0x2C9D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C9E, 0x2C9E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2C9F, 0x2C9F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CA0, 0x2CA0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CA1, 0x2CA1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CA2, 0x2CA2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CA3, 0x2CA3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CA4, 0x2CA4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CA5, 0x2CA5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CA6, 0x2CA6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CA7, 0x2CA7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CA8, 0x2CA8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CA9, 0x2CA9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CAA, 0x2CAA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CAB, 0x2CAB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CAC, 0x2CAC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CAD, 0x2CAD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CAE, 0x2CAE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CAF, 0x2CAF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CB0, 0x2CB0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CB1, 0x2CB1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CB2, 0x2CB2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CB3, 0x2CB3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CB4, 0x2CB4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CB5, 0x2CB5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CB6, 0x2CB6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CB7, 0x2CB7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CB8, 0x2CB8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CB9, 0x2CB9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CBA, 0x2CBA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CBB, 0x2CBB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CBC, 0x2CBC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CBD, 0x2CBD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CBE, 0x2CBE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CBF, 0x2CBF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CC0, 0x2CC0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CC1, 0x2CC1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CC2, 0x2CC2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CC3, 0x2CC3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CC4, 0x2CC4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			return i;
		}

		private int initialize5 (int i) {
			mRanges[i++] = new CharPropRange (0x2CC5, 0x2CC5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CC6, 0x2CC6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CC7, 0x2CC7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CC8, 0x2CC8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CC9, 0x2CC9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CCA, 0x2CCA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CCB, 0x2CCB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CCC, 0x2CCC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CCD, 0x2CCD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CCE, 0x2CCE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CCF, 0x2CCF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CD0, 0x2CD0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CD1, 0x2CD1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CD2, 0x2CD2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CD3, 0x2CD3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CD4, 0x2CD4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CD5, 0x2CD5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CD6, 0x2CD6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CD7, 0x2CD7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CD8, 0x2CD8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CD9, 0x2CD9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CDA, 0x2CDA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CDB, 0x2CDB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CDC, 0x2CDC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CDD, 0x2CDD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CDE, 0x2CDE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CDF, 0x2CDF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CE0, 0x2CE0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CE1, 0x2CE1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CE2, 0x2CE2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CE3, 0x2CE4, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CE5, 0x2CEA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CF9, 0x2CFC, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CFD, 0x2CFD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2CFE, 0x2CFF, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2D00, 0x2D25, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2D30, 0x2D65, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2D6F, 0x2D6F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2D80, 0x2D96, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2DA0, 0x2DA6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2DA8, 0x2DAE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2DB0, 0x2DB6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2DB8, 0x2DBE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2DC0, 0x2DC6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2DC8, 0x2DCE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2DD0, 0x2DD6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2DD8, 0x2DDE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2E00, 0x2E01, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2E02, 0x2E05, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2E06, 0x2E08, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2E09, 0x2E0A, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2E0B, 0x2E0B, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2E0C, 0x2E0D, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2E0E, 0x2E15, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2E16, 0x2E16, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2E17, 0x2E17, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2E1C, 0x2E1D, makeData (BREAK_QU, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x2E80, 0x2E99, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2E9B, 0x2EF3, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2F00, 0x2FD5, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2FF0, 0x2FFB, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3000, 0x3000, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_WS, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3001, 0x3002, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3003, 0x3004, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3005, 0x3005, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3006, 0x3007, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3008, 0x3008, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x3009, 0x3009, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x300A, 0x300A, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x300B, 0x300B, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x300C, 0x300C, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x300D, 0x300D, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x300E, 0x300E, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x300F, 0x300F, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x3010, 0x3010, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x3011, 0x3011, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x3012, 0x3013, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3014, 0x3014, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x3015, 0x3015, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x3016, 0x3016, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x3017, 0x3017, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x3018, 0x3018, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x3019, 0x3019, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x301A, 0x301A, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x301B, 0x301B, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x301C, 0x301C, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x301D, 0x301D, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x301E, 0x301E, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0x301F, 0x301F, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3020, 0x3020, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3021, 0x3029, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x302A, 0x302F, makeData (BREAK_CM, WIDTH_W, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3030, 0x3030, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3031, 0x3035, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3036, 0x3037, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3038, 0x303A, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x303B, 0x303C, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x303D, 0x303E, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x303F, 0x303F, makeData (BREAK_ID, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3041, 0x3041, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3042, 0x3042, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3043, 0x3043, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3044, 0x3044, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3045, 0x3045, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3046, 0x3046, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3047, 0x3047, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3048, 0x3048, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3049, 0x3049, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x304A, 0x3062, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3063, 0x3063, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3064, 0x3082, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3083, 0x3083, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3084, 0x3084, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3085, 0x3085, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3086, 0x3086, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3087, 0x3087, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3088, 0x308D, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x308E, 0x308E, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x308F, 0x3094, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3095, 0x3096, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3099, 0x309A, makeData (BREAK_CM, WIDTH_W, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x309B, 0x309C, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x309D, 0x309E, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x309F, 0x309F, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30A0, 0x30A0, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30A1, 0x30A1, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30A2, 0x30A2, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30A3, 0x30A3, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30A4, 0x30A4, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30A5, 0x30A5, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30A6, 0x30A6, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30A7, 0x30A7, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30A8, 0x30A8, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30A9, 0x30A9, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30AA, 0x30C2, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30C3, 0x30C3, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30C4, 0x30E2, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30E3, 0x30E3, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30E4, 0x30E4, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30E5, 0x30E5, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30E6, 0x30E6, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30E7, 0x30E7, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30E8, 0x30ED, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30EE, 0x30EE, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30EF, 0x30F4, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30F5, 0x30F6, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30F7, 0x30FA, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30FB, 0x30FB, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30FC, 0x30FE, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30FF, 0x30FF, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3105, 0x312C, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3131, 0x318E, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3190, 0x319F, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x31A0, 0x31B7, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x31C0, 0x31CF, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x31F0, 0x31FF, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3200, 0x321C, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x321D, 0x321E, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3220, 0x3243, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3250, 0x325F, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3260, 0x327B, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x327C, 0x327E, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x327F, 0x32B0, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x32B1, 0x32BF, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x32C0, 0x32CB, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x32CC, 0x32CF, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x32D0, 0x32FE, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3300, 0x3376, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3377, 0x337A, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x337B, 0x33DD, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x33DE, 0x33DF, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x33E0, 0x33FE, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x33FF, 0x33FF, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3400, 0x4DB5, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x4DC0, 0x4DFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x4E00, 0x9FBB, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA000, 0xA014, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA015, 0xA015, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA016, 0xA48C, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA490, 0xA4C6, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA700, 0xA71A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA720, 0xA721, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA800, 0xA801, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA802, 0xA802, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA803, 0xA805, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA806, 0xA806, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA807, 0xA80A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA80B, 0xA80B, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA80C, 0xA822, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA823, 0xA824, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA825, 0xA826, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA827, 0xA827, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA828, 0xA82B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA840, 0xA873, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xA874, 0xA877, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC00, 0xAC00, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC01, 0xAC1B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC1C, 0xAC1C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC1D, 0xAC37, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC38, 0xAC38, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC39, 0xAC53, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC54, 0xAC54, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC55, 0xAC6F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC70, 0xAC70, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC71, 0xAC8B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC8C, 0xAC8C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAC8D, 0xACA7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xACA8, 0xACA8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xACA9, 0xACC3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xACC4, 0xACC4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xACC5, 0xACDF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xACE0, 0xACE0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xACE1, 0xACFB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xACFC, 0xACFC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xACFD, 0xAD17, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAD18, 0xAD18, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAD19, 0xAD33, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAD34, 0xAD34, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAD35, 0xAD4F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAD50, 0xAD50, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAD51, 0xAD6B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAD6C, 0xAD6C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAD6D, 0xAD87, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAD88, 0xAD88, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAD89, 0xADA3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xADA4, 0xADA4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xADA5, 0xADBF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xADC0, 0xADC0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xADC1, 0xADDB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xADDC, 0xADDC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xADDD, 0xADF7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xADF8, 0xADF8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xADF9, 0xAE13, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAE14, 0xAE14, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAE15, 0xAE2F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAE30, 0xAE30, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAE31, 0xAE4B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAE4C, 0xAE4C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAE4D, 0xAE67, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAE68, 0xAE68, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAE69, 0xAE83, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAE84, 0xAE84, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAE85, 0xAE9F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAEA0, 0xAEA0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAEA1, 0xAEBB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAEBC, 0xAEBC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAEBD, 0xAED7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAED8, 0xAED8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAED9, 0xAEF3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAEF4, 0xAEF4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAEF5, 0xAF0F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF10, 0xAF10, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF11, 0xAF2B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF2C, 0xAF2C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF2D, 0xAF47, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF48, 0xAF48, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF49, 0xAF63, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF64, 0xAF64, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF65, 0xAF7F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF80, 0xAF80, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF81, 0xAF9B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF9C, 0xAF9C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAF9D, 0xAFB7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAFB8, 0xAFB8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAFB9, 0xAFD3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAFD4, 0xAFD4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAFD5, 0xAFEF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAFF0, 0xAFF0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAFF1, 0xB00B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB00C, 0xB00C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB00D, 0xB027, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB028, 0xB028, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB029, 0xB043, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB044, 0xB044, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB045, 0xB05F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB060, 0xB060, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB061, 0xB07B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB07C, 0xB07C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB07D, 0xB097, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB098, 0xB098, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB099, 0xB0B3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB0B4, 0xB0B4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB0B5, 0xB0CF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB0D0, 0xB0D0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB0D1, 0xB0EB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB0EC, 0xB0EC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB0ED, 0xB107, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB108, 0xB108, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB109, 0xB123, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB124, 0xB124, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB125, 0xB13F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB140, 0xB140, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB141, 0xB15B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB15C, 0xB15C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB15D, 0xB177, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB178, 0xB178, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB179, 0xB193, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB194, 0xB194, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB195, 0xB1AF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB1B0, 0xB1B0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB1B1, 0xB1CB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB1CC, 0xB1CC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB1CD, 0xB1E7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB1E8, 0xB1E8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB1E9, 0xB203, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB204, 0xB204, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB205, 0xB21F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB220, 0xB220, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB221, 0xB23B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB23C, 0xB23C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB23D, 0xB257, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB258, 0xB258, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB259, 0xB273, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB274, 0xB274, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB275, 0xB28F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB290, 0xB290, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB291, 0xB2AB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB2AC, 0xB2AC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB2AD, 0xB2C7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB2C8, 0xB2C8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB2C9, 0xB2E3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB2E4, 0xB2E4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB2E5, 0xB2FF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB300, 0xB300, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB301, 0xB31B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB31C, 0xB31C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB31D, 0xB337, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB338, 0xB338, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB339, 0xB353, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB354, 0xB354, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB355, 0xB36F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB370, 0xB370, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB371, 0xB38B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB38C, 0xB38C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB38D, 0xB3A7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB3A8, 0xB3A8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB3A9, 0xB3C3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB3C4, 0xB3C4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB3C5, 0xB3DF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB3E0, 0xB3E0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB3E1, 0xB3FB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB3FC, 0xB3FC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB3FD, 0xB417, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB418, 0xB418, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB419, 0xB433, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB434, 0xB434, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB435, 0xB44F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB450, 0xB450, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB451, 0xB46B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB46C, 0xB46C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB46D, 0xB487, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB488, 0xB488, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB489, 0xB4A3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB4A4, 0xB4A4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB4A5, 0xB4BF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB4C0, 0xB4C0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB4C1, 0xB4DB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB4DC, 0xB4DC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB4DD, 0xB4F7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB4F8, 0xB4F8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB4F9, 0xB513, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB514, 0xB514, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB515, 0xB52F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB530, 0xB530, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB531, 0xB54B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB54C, 0xB54C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB54D, 0xB567, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB568, 0xB568, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB569, 0xB583, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB584, 0xB584, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB585, 0xB59F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB5A0, 0xB5A0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB5A1, 0xB5BB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB5BC, 0xB5BC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB5BD, 0xB5D7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB5D8, 0xB5D8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB5D9, 0xB5F3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB5F4, 0xB5F4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB5F5, 0xB60F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB610, 0xB610, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB611, 0xB62B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB62C, 0xB62C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB62D, 0xB647, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB648, 0xB648, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB649, 0xB663, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB664, 0xB664, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB665, 0xB67F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB680, 0xB680, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB681, 0xB69B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB69C, 0xB69C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB69D, 0xB6B7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB6B8, 0xB6B8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB6B9, 0xB6D3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB6D4, 0xB6D4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB6D5, 0xB6EF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB6F0, 0xB6F0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB6F1, 0xB70B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB70C, 0xB70C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB70D, 0xB727, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB728, 0xB728, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB729, 0xB743, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB744, 0xB744, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB745, 0xB75F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB760, 0xB760, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB761, 0xB77B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB77C, 0xB77C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB77D, 0xB797, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB798, 0xB798, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB799, 0xB7B3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB7B4, 0xB7B4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB7B5, 0xB7CF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB7D0, 0xB7D0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB7D1, 0xB7EB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB7EC, 0xB7EC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB7ED, 0xB807, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB808, 0xB808, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB809, 0xB823, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB824, 0xB824, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB825, 0xB83F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB840, 0xB840, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB841, 0xB85B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB85C, 0xB85C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB85D, 0xB877, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB878, 0xB878, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB879, 0xB893, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB894, 0xB894, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB895, 0xB8AF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB8B0, 0xB8B0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB8B1, 0xB8CB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB8CC, 0xB8CC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB8CD, 0xB8E7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB8E8, 0xB8E8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB8E9, 0xB903, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB904, 0xB904, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB905, 0xB91F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB920, 0xB920, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB921, 0xB93B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB93C, 0xB93C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB93D, 0xB957, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB958, 0xB958, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB959, 0xB973, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB974, 0xB974, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB975, 0xB98F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB990, 0xB990, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB991, 0xB9AB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB9AC, 0xB9AC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB9AD, 0xB9C7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB9C8, 0xB9C8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB9C9, 0xB9E3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB9E4, 0xB9E4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xB9E5, 0xB9FF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA00, 0xBA00, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA01, 0xBA1B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA1C, 0xBA1C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA1D, 0xBA37, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA38, 0xBA38, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA39, 0xBA53, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA54, 0xBA54, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA55, 0xBA6F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA70, 0xBA70, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA71, 0xBA8B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA8C, 0xBA8C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBA8D, 0xBAA7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBAA8, 0xBAA8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBAA9, 0xBAC3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBAC4, 0xBAC4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBAC5, 0xBADF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBAE0, 0xBAE0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBAE1, 0xBAFB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBAFC, 0xBAFC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBAFD, 0xBB17, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBB18, 0xBB18, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBB19, 0xBB33, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBB34, 0xBB34, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBB35, 0xBB4F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBB50, 0xBB50, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBB51, 0xBB6B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBB6C, 0xBB6C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBB6D, 0xBB87, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBB88, 0xBB88, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBB89, 0xBBA3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBBA4, 0xBBA4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBBA5, 0xBBBF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBBC0, 0xBBC0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBBC1, 0xBBDB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBBDC, 0xBBDC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBBDD, 0xBBF7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBBF8, 0xBBF8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBBF9, 0xBC13, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBC14, 0xBC14, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBC15, 0xBC2F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBC30, 0xBC30, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBC31, 0xBC4B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBC4C, 0xBC4C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBC4D, 0xBC67, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBC68, 0xBC68, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBC69, 0xBC83, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBC84, 0xBC84, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBC85, 0xBC9F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBCA0, 0xBCA0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBCA1, 0xBCBB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			return i;
		}

		private int initialize6 (int i) {
			mRanges[i++] = new CharPropRange (0xBCBC, 0xBCBC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBCBD, 0xBCD7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBCD8, 0xBCD8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBCD9, 0xBCF3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBCF4, 0xBCF4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBCF5, 0xBD0F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD10, 0xBD10, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD11, 0xBD2B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD2C, 0xBD2C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD2D, 0xBD47, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD48, 0xBD48, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD49, 0xBD63, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD64, 0xBD64, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD65, 0xBD7F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD80, 0xBD80, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD81, 0xBD9B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD9C, 0xBD9C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBD9D, 0xBDB7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBDB8, 0xBDB8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBDB9, 0xBDD3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBDD4, 0xBDD4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBDD5, 0xBDEF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBDF0, 0xBDF0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBDF1, 0xBE0B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE0C, 0xBE0C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE0D, 0xBE27, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE28, 0xBE28, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE29, 0xBE43, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE44, 0xBE44, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE45, 0xBE5F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE60, 0xBE60, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE61, 0xBE7B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE7C, 0xBE7C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE7D, 0xBE97, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE98, 0xBE98, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBE99, 0xBEB3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBEB4, 0xBEB4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBEB5, 0xBECF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBED0, 0xBED0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBED1, 0xBEEB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBEEC, 0xBEEC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBEED, 0xBF07, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF08, 0xBF08, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF09, 0xBF23, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF24, 0xBF24, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF25, 0xBF3F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF40, 0xBF40, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF41, 0xBF5B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF5C, 0xBF5C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF5D, 0xBF77, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF78, 0xBF78, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF79, 0xBF93, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF94, 0xBF94, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBF95, 0xBFAF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBFB0, 0xBFB0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBFB1, 0xBFCB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBFCC, 0xBFCC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBFCD, 0xBFE7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBFE8, 0xBFE8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBFE9, 0xC003, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC004, 0xC004, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC005, 0xC01F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC020, 0xC020, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC021, 0xC03B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC03C, 0xC03C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC03D, 0xC057, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC058, 0xC058, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC059, 0xC073, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC074, 0xC074, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC075, 0xC08F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC090, 0xC090, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC091, 0xC0AB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC0AC, 0xC0AC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC0AD, 0xC0C7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC0C8, 0xC0C8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC0C9, 0xC0E3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC0E4, 0xC0E4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC0E5, 0xC0FF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC100, 0xC100, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC101, 0xC11B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC11C, 0xC11C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC11D, 0xC137, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC138, 0xC138, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC139, 0xC153, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC154, 0xC154, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC155, 0xC16F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC170, 0xC170, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC171, 0xC18B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC18C, 0xC18C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC18D, 0xC1A7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC1A8, 0xC1A8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC1A9, 0xC1C3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC1C4, 0xC1C4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC1C5, 0xC1DF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC1E0, 0xC1E0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC1E1, 0xC1FB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC1FC, 0xC1FC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC1FD, 0xC217, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC218, 0xC218, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC219, 0xC233, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC234, 0xC234, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC235, 0xC24F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC250, 0xC250, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC251, 0xC26B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC26C, 0xC26C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC26D, 0xC287, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC288, 0xC288, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC289, 0xC2A3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC2A4, 0xC2A4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC2A5, 0xC2BF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC2C0, 0xC2C0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC2C1, 0xC2DB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC2DC, 0xC2DC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC2DD, 0xC2F7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC2F8, 0xC2F8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC2F9, 0xC313, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC314, 0xC314, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC315, 0xC32F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC330, 0xC330, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC331, 0xC34B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC34C, 0xC34C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC34D, 0xC367, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC368, 0xC368, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC369, 0xC383, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC384, 0xC384, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC385, 0xC39F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC3A0, 0xC3A0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC3A1, 0xC3BB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC3BC, 0xC3BC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC3BD, 0xC3D7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC3D8, 0xC3D8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC3D9, 0xC3F3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC3F4, 0xC3F4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC3F5, 0xC40F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC410, 0xC410, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC411, 0xC42B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC42C, 0xC42C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC42D, 0xC447, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC448, 0xC448, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC449, 0xC463, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC464, 0xC464, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC465, 0xC47F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC480, 0xC480, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC481, 0xC49B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC49C, 0xC49C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC49D, 0xC4B7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC4B8, 0xC4B8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC4B9, 0xC4D3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC4D4, 0xC4D4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC4D5, 0xC4EF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC4F0, 0xC4F0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC4F1, 0xC50B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC50C, 0xC50C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC50D, 0xC527, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC528, 0xC528, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC529, 0xC543, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC544, 0xC544, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC545, 0xC55F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC560, 0xC560, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC561, 0xC57B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC57C, 0xC57C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC57D, 0xC597, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC598, 0xC598, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC599, 0xC5B3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC5B4, 0xC5B4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC5B5, 0xC5CF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC5D0, 0xC5D0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC5D1, 0xC5EB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC5EC, 0xC5EC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC5ED, 0xC607, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC608, 0xC608, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC609, 0xC623, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC624, 0xC624, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC625, 0xC63F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC640, 0xC640, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC641, 0xC65B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC65C, 0xC65C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC65D, 0xC677, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC678, 0xC678, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC679, 0xC693, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC694, 0xC694, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC695, 0xC6AF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC6B0, 0xC6B0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC6B1, 0xC6CB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC6CC, 0xC6CC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC6CD, 0xC6E7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC6E8, 0xC6E8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC6E9, 0xC703, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC704, 0xC704, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC705, 0xC71F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC720, 0xC720, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC721, 0xC73B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC73C, 0xC73C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC73D, 0xC757, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC758, 0xC758, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC759, 0xC773, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC774, 0xC774, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC775, 0xC78F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC790, 0xC790, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC791, 0xC7AB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC7AC, 0xC7AC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC7AD, 0xC7C7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC7C8, 0xC7C8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC7C9, 0xC7E3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC7E4, 0xC7E4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC7E5, 0xC7FF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC800, 0xC800, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC801, 0xC81B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC81C, 0xC81C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC81D, 0xC837, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC838, 0xC838, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC839, 0xC853, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC854, 0xC854, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC855, 0xC86F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC870, 0xC870, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC871, 0xC88B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC88C, 0xC88C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC88D, 0xC8A7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC8A8, 0xC8A8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC8A9, 0xC8C3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC8C4, 0xC8C4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC8C5, 0xC8DF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC8E0, 0xC8E0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC8E1, 0xC8FB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC8FC, 0xC8FC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC8FD, 0xC917, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC918, 0xC918, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC919, 0xC933, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC934, 0xC934, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC935, 0xC94F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC950, 0xC950, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC951, 0xC96B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC96C, 0xC96C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC96D, 0xC987, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC988, 0xC988, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC989, 0xC9A3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC9A4, 0xC9A4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC9A5, 0xC9BF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC9C0, 0xC9C0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC9C1, 0xC9DB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC9DC, 0xC9DC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC9DD, 0xC9F7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC9F8, 0xC9F8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xC9F9, 0xCA13, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCA14, 0xCA14, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCA15, 0xCA2F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCA30, 0xCA30, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCA31, 0xCA4B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCA4C, 0xCA4C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCA4D, 0xCA67, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCA68, 0xCA68, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCA69, 0xCA83, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCA84, 0xCA84, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCA85, 0xCA9F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCAA0, 0xCAA0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCAA1, 0xCABB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCABC, 0xCABC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCABD, 0xCAD7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCAD8, 0xCAD8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCAD9, 0xCAF3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCAF4, 0xCAF4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCAF5, 0xCB0F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB10, 0xCB10, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB11, 0xCB2B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB2C, 0xCB2C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB2D, 0xCB47, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB48, 0xCB48, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB49, 0xCB63, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB64, 0xCB64, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB65, 0xCB7F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB80, 0xCB80, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB81, 0xCB9B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB9C, 0xCB9C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCB9D, 0xCBB7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCBB8, 0xCBB8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCBB9, 0xCBD3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCBD4, 0xCBD4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCBD5, 0xCBEF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCBF0, 0xCBF0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCBF1, 0xCC0B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC0C, 0xCC0C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC0D, 0xCC27, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC28, 0xCC28, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC29, 0xCC43, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC44, 0xCC44, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC45, 0xCC5F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC60, 0xCC60, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC61, 0xCC7B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC7C, 0xCC7C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC7D, 0xCC97, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC98, 0xCC98, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCC99, 0xCCB3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCCB4, 0xCCB4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCCB5, 0xCCCF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCCD0, 0xCCD0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCCD1, 0xCCEB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCCEC, 0xCCEC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCCED, 0xCD07, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD08, 0xCD08, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD09, 0xCD23, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD24, 0xCD24, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD25, 0xCD3F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD40, 0xCD40, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD41, 0xCD5B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD5C, 0xCD5C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD5D, 0xCD77, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD78, 0xCD78, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD79, 0xCD93, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD94, 0xCD94, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCD95, 0xCDAF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCDB0, 0xCDB0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCDB1, 0xCDCB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCDCC, 0xCDCC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCDCD, 0xCDE7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCDE8, 0xCDE8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCDE9, 0xCE03, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE04, 0xCE04, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE05, 0xCE1F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE20, 0xCE20, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE21, 0xCE3B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE3C, 0xCE3C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE3D, 0xCE57, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE58, 0xCE58, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE59, 0xCE73, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE74, 0xCE74, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE75, 0xCE8F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE90, 0xCE90, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCE91, 0xCEAB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCEAC, 0xCEAC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCEAD, 0xCEC7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCEC8, 0xCEC8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCEC9, 0xCEE3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCEE4, 0xCEE4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCEE5, 0xCEFF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF00, 0xCF00, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF01, 0xCF1B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF1C, 0xCF1C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF1D, 0xCF37, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF38, 0xCF38, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF39, 0xCF53, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF54, 0xCF54, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF55, 0xCF6F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF70, 0xCF70, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF71, 0xCF8B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF8C, 0xCF8C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCF8D, 0xCFA7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCFA8, 0xCFA8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCFA9, 0xCFC3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCFC4, 0xCFC4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCFC5, 0xCFDF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCFE0, 0xCFE0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCFE1, 0xCFFB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCFFC, 0xCFFC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCFFD, 0xD017, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD018, 0xD018, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD019, 0xD033, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD034, 0xD034, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD035, 0xD04F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD050, 0xD050, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD051, 0xD06B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD06C, 0xD06C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD06D, 0xD087, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD088, 0xD088, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD089, 0xD0A3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD0A4, 0xD0A4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD0A5, 0xD0BF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD0C0, 0xD0C0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD0C1, 0xD0DB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD0DC, 0xD0DC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD0DD, 0xD0F7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD0F8, 0xD0F8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD0F9, 0xD113, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD114, 0xD114, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD115, 0xD12F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD130, 0xD130, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD131, 0xD14B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD14C, 0xD14C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD14D, 0xD167, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD168, 0xD168, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD169, 0xD183, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD184, 0xD184, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD185, 0xD19F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD1A0, 0xD1A0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD1A1, 0xD1BB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD1BC, 0xD1BC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD1BD, 0xD1D7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD1D8, 0xD1D8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD1D9, 0xD1F3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD1F4, 0xD1F4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD1F5, 0xD20F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD210, 0xD210, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD211, 0xD22B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD22C, 0xD22C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD22D, 0xD247, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD248, 0xD248, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD249, 0xD263, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD264, 0xD264, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD265, 0xD27F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD280, 0xD280, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD281, 0xD29B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD29C, 0xD29C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD29D, 0xD2B7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD2B8, 0xD2B8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD2B9, 0xD2D3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD2D4, 0xD2D4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD2D5, 0xD2EF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD2F0, 0xD2F0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD2F1, 0xD30B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD30C, 0xD30C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD30D, 0xD327, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD328, 0xD328, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD329, 0xD343, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD344, 0xD344, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD345, 0xD35F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD360, 0xD360, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD361, 0xD37B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD37C, 0xD37C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD37D, 0xD397, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD398, 0xD398, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD399, 0xD3B3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD3B4, 0xD3B4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD3B5, 0xD3CF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD3D0, 0xD3D0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD3D1, 0xD3EB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD3EC, 0xD3EC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD3ED, 0xD407, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD408, 0xD408, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD409, 0xD423, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD424, 0xD424, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD425, 0xD43F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD440, 0xD440, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD441, 0xD45B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD45C, 0xD45C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD45D, 0xD477, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD478, 0xD478, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD479, 0xD493, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD494, 0xD494, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD495, 0xD4AF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD4B0, 0xD4B0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD4B1, 0xD4CB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD4CC, 0xD4CC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD4CD, 0xD4E7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD4E8, 0xD4E8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD4E9, 0xD503, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD504, 0xD504, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD505, 0xD51F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD520, 0xD520, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD521, 0xD53B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD53C, 0xD53C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD53D, 0xD557, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD558, 0xD558, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD559, 0xD573, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD574, 0xD574, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD575, 0xD58F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD590, 0xD590, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD591, 0xD5AB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD5AC, 0xD5AC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD5AD, 0xD5C7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD5C8, 0xD5C8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD5C9, 0xD5E3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD5E4, 0xD5E4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD5E5, 0xD5FF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD600, 0xD600, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD601, 0xD61B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD61C, 0xD61C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD61D, 0xD637, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD638, 0xD638, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD639, 0xD653, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD654, 0xD654, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD655, 0xD66F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD670, 0xD670, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD671, 0xD68B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD68C, 0xD68C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD68D, 0xD6A7, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD6A8, 0xD6A8, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD6A9, 0xD6C3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD6C4, 0xD6C4, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD6C5, 0xD6DF, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD6E0, 0xD6E0, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD6E1, 0xD6FB, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD6FC, 0xD6FC, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD6FD, 0xD717, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD718, 0xD718, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD719, 0xD733, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD734, 0xD734, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD735, 0xD74F, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD750, 0xD750, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD751, 0xD76B, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD76C, 0xD76C, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD76D, 0xD787, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD788, 0xD788, makeData (BREAK_H2, WIDTH_W, GRAPHEME_LV, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD789, 0xD7A3, makeData (BREAK_H3, WIDTH_W, GRAPHEME_LVT, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xD800, 0xDFFF, makeData (BREAK_SG, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xE000, 0xF8FF, makeData (BREAK_XX, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xF900, 0xFA2D, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFA30, 0xFA6A, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFA70, 0xFAD9, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB00, 0xFB06, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB13, 0xFB17, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB1D, 0xFB1D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB1E, 0xFB1E, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			return i;
		}

		private int initialize7 (int i) {
			mRanges[i++] = new CharPropRange (0xFB1F, 0xFB28, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB29, 0xFB29, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ES, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB2A, 0xFB36, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB37, 0xFB37, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB38, 0xFB3C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB3D, 0xFB3D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB3E, 0xFB3E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB3F, 0xFB3F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB40, 0xFB41, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB42, 0xFB42, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB43, 0xFB44, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB45, 0xFB45, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB46, 0xFB4F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFB50, 0xFBB1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFBB2, 0xFBD2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFBD3, 0xFD3D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFD3E, 0xFD3E, makeData (BREAK_OP, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFD3F, 0xFD3F, makeData (BREAK_CL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFD40, 0xFD4F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFD50, 0xFD8F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFD90, 0xFD91, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFD92, 0xFDC7, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFDC8, 0xFDCF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFDD0, 0xFDEF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFDF0, 0xFDFB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFDFC, 0xFDFC, makeData (BREAK_PO, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFDFD, 0xFDFD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFDFE, 0xFDFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE00, 0xFE0F, makeData (BREAK_CM, WIDTH_A, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE10, 0xFE10, makeData (BREAK_IS, WIDTH_W, GRAPHEME_Default, WORD_MidNum, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE11, 0xFE12, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE13, 0xFE14, makeData (BREAK_IS, WIDTH_W, GRAPHEME_Default, WORD_MidNum, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE15, 0xFE16, makeData (BREAK_EX, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE17, 0xFE17, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE18, 0xFE18, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE19, 0xFE19, makeData (BREAK_IN, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE20, 0xFE23, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE30, 0xFE32, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE33, 0xFE34, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_ExtendNumLet, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE35, 0xFE35, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE36, 0xFE36, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE37, 0xFE37, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE38, 0xFE38, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE39, 0xFE39, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE3A, 0xFE3A, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE3B, 0xFE3B, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE3C, 0xFE3C, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE3D, 0xFE3D, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE3E, 0xFE3E, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE3F, 0xFE3F, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE40, 0xFE40, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE41, 0xFE41, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE42, 0xFE42, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE43, 0xFE43, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE44, 0xFE44, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE45, 0xFE46, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE47, 0xFE47, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE48, 0xFE48, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE49, 0xFE4C, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE4D, 0xFE4F, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_ExtendNumLet, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE50, 0xFE50, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE51, 0xFE51, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE52, 0xFE52, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE54, 0xFE54, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE55, 0xFE55, makeData (BREAK_NS, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE56, 0xFE57, makeData (BREAK_EX, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE58, 0xFE58, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE59, 0xFE59, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFE5A, 0xFE5A, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFE5B, 0xFE5B, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFE5C, 0xFE5C, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFE5D, 0xFE5D, makeData (BREAK_OP, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFE5E, 0xFE5E, makeData (BREAK_CL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFE5F, 0xFE5F, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE60, 0xFE61, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE62, 0xFE63, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ES, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE64, 0xFE65, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFE66, 0xFE66, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE68, 0xFE68, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE69, 0xFE69, makeData (BREAK_PR, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE6A, 0xFE6A, makeData (BREAK_PO, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE6B, 0xFE6B, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE70, 0xFE74, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE75, 0xFE75, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFE76, 0xFEFC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFEFD, 0xFEFE, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFEFF, 0xFEFF, makeData (BREAK_WJ, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF01, 0xFF01, makeData (BREAK_EX, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF02, 0xFF02, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF03, 0xFF03, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF04, 0xFF04, makeData (BREAK_PR, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF05, 0xFF05, makeData (BREAK_PO, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF06, 0xFF07, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF08, 0xFF08, makeData (BREAK_OP, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF09, 0xFF09, makeData (BREAK_CL, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF0A, 0xFF0A, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF0B, 0xFF0B, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ES, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF0C, 0xFF0C, makeData (BREAK_CL, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF0D, 0xFF0D, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ES, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF0E, 0xFF0E, makeData (BREAK_CL, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF0F, 0xFF0F, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF10, 0xFF19, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF1A, 0xFF1A, makeData (BREAK_NS, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_CS, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF1B, 0xFF1B, makeData (BREAK_NS, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF1C, 0xFF1C, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF1D, 0xFF1D, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF1E, 0xFF1E, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF1F, 0xFF1F, makeData (BREAK_EX, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF20, 0xFF20, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF21, 0xFF3A, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF3B, 0xFF3B, makeData (BREAK_OP, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF3C, 0xFF3C, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF3D, 0xFF3D, makeData (BREAK_CL, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF3E, 0xFF3E, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF3F, 0xFF3F, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_ExtendNumLet, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF40, 0xFF40, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF41, 0xFF5A, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF5B, 0xFF5B, makeData (BREAK_OP, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF5C, 0xFF5C, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF5D, 0xFF5D, makeData (BREAK_CL, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF5E, 0xFF5E, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF5F, 0xFF5F, makeData (BREAK_OP, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF60, 0xFF60, makeData (BREAK_CL, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF61, 0xFF61, makeData (BREAK_CL, WIDTH_H, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF62, 0xFF62, makeData (BREAK_OP, WIDTH_H, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF63, 0xFF63, makeData (BREAK_CL, WIDTH_H, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_ON));
			mRanges[i++] = new CharPropRange (0xFF64, 0xFF64, makeData (BREAK_CL, WIDTH_H, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF65, 0xFF65, makeData (BREAK_NS, WIDTH_H, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF66, 0xFF66, makeData (BREAK_AL, WIDTH_H, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF67, 0xFF70, makeData (BREAK_NS, WIDTH_H, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF71, 0xFF9D, makeData (BREAK_AL, WIDTH_H, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFF9E, 0xFF9F, makeData (BREAK_NS, WIDTH_H, GRAPHEME_Default, WORD_Katakana, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFA0, 0xFFBE, makeData (BREAK_AL, WIDTH_H, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFC2, 0xFFC7, makeData (BREAK_AL, WIDTH_H, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFCA, 0xFFCF, makeData (BREAK_AL, WIDTH_H, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFD2, 0xFFD7, makeData (BREAK_AL, WIDTH_H, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFDA, 0xFFDC, makeData (BREAK_AL, WIDTH_H, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFE0, 0xFFE0, makeData (BREAK_PO, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFE1, 0xFFE1, makeData (BREAK_PR, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFE2, 0xFFE4, makeData (BREAK_ID, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFE5, 0xFFE6, makeData (BREAK_PR, WIDTH_F, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ET, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFE8, 0xFFEE, makeData (BREAK_AL, WIDTH_H, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFF0, 0xFFF8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFF9, 0xFFFB, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFFC, 0xFFFC, makeData (BREAK_CB, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFFD, 0xFFFD, makeData (BREAK_AI, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFFE, 0xFFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10000, 0x1000B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1000D, 0x10026, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10028, 0x1003A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1003C, 0x1003D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1003F, 0x1004D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10050, 0x1005D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10080, 0x100FA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10100, 0x10100, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10101, 0x10101, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10102, 0x10102, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10107, 0x10133, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10137, 0x1013F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10140, 0x10174, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10175, 0x1018A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10300, 0x1031E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10320, 0x10323, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10330, 0x1034A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10380, 0x1039D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1039E, 0x1039E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_AL, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1039F, 0x1039F, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x103A0, 0x103C3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x103C8, 0x103CF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x103D0, 0x103D0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x103D1, 0x103D5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10400, 0x10427, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10428, 0x1044F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10450, 0x1049D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x104A0, 0x104A9, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10800, 0x10805, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10806, 0x10807, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10808, 0x10808, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10809, 0x10809, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1080A, 0x10835, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10836, 0x10836, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10837, 0x10838, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10839, 0x1083B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1083C, 0x1083C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1083D, 0x1083E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1083F, 0x1083F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10840, 0x1091E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1091F, 0x1091F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10920, 0x109FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A00, 0x10A00, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A01, 0x10A03, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A04, 0x10A04, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A05, 0x10A06, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A07, 0x10A0B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A0C, 0x10A0F, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A10, 0x10A13, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A14, 0x10A14, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A15, 0x10A17, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A18, 0x10A18, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A19, 0x10A33, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A34, 0x10A37, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A38, 0x10A3A, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A3B, 0x10A3E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A3F, 0x10A3F, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A40, 0x10A4F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A50, 0x10A57, makeData (BREAK_BA, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10A58, 0x10FFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_R, BM_OFF));
			mRanges[i++] = new CharPropRange (0x12000, 0x1236E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x12400, 0x12462, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x12470, 0x12473, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D000, 0x1D0F5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D100, 0x1D126, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D12A, 0x1D164, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D165, 0x1D165, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D166, 0x1D166, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D167, 0x1D169, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D16A, 0x1D16C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D16D, 0x1D16D, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D16E, 0x1D172, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D173, 0x1D17A, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D17B, 0x1D182, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D183, 0x1D184, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D185, 0x1D18B, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D18C, 0x1D1A9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D1AA, 0x1D1AD, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D1AE, 0x1D1DD, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D200, 0x1D241, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D242, 0x1D244, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D245, 0x1D245, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D300, 0x1D356, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_ON, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D360, 0x1D371, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D400, 0x1D419, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D41A, 0x1D433, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D434, 0x1D44D, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D44E, 0x1D454, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D456, 0x1D467, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D468, 0x1D481, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D482, 0x1D49B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D49C, 0x1D49C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D49E, 0x1D49F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D4A2, 0x1D4A2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D4A5, 0x1D4A6, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D4A9, 0x1D4AC, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D4AE, 0x1D4B5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D4B6, 0x1D4B9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D4BB, 0x1D4BB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D4BD, 0x1D4C3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D4C5, 0x1D4CF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D4D0, 0x1D4E9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D4EA, 0x1D503, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D504, 0x1D505, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D507, 0x1D50A, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D50D, 0x1D514, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D516, 0x1D51C, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D51E, 0x1D537, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D538, 0x1D539, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D53B, 0x1D53E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D540, 0x1D544, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D546, 0x1D546, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D54A, 0x1D550, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D552, 0x1D56B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D56C, 0x1D585, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D586, 0x1D59F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D5A0, 0x1D5B9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D5BA, 0x1D5D3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D5D4, 0x1D5ED, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D5EE, 0x1D607, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D608, 0x1D621, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D622, 0x1D63B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D63C, 0x1D655, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D656, 0x1D66F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D670, 0x1D689, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D68A, 0x1D6A5, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D6A8, 0x1D6C0, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D6C1, 0x1D6C1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D6C2, 0x1D6DA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D6DB, 0x1D6DB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D6DC, 0x1D6E1, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D6E2, 0x1D6FA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D6FB, 0x1D6FB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D6FC, 0x1D714, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D715, 0x1D715, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D716, 0x1D71B, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D71C, 0x1D734, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D735, 0x1D735, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D736, 0x1D74E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D74F, 0x1D74F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D750, 0x1D755, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D756, 0x1D76E, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D76F, 0x1D76F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D770, 0x1D788, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D789, 0x1D789, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D78A, 0x1D78F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D790, 0x1D7A8, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D7A9, 0x1D7A9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D7AA, 0x1D7C2, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D7C3, 0x1D7C3, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D7C4, 0x1D7C9, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_ALetter, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D7CA, 0x1D7CA, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Uppercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D7CB, 0x1D7CB, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Lowercase, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1D7CE, 0x1D7FF, makeData (BREAK_NU, WIDTH_N, GRAPHEME_Default, WORD_Numeric, CASE_Default, BIDI_EN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x1FFFE, 0x1FFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x20000, 0x2A6D6, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2A6D7, 0x2F7FF, makeData (BREAK_AL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2F800, 0x2FA1D, makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2FA1E, 0x2FFFD, makeData (BREAK_AL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x2FFFE, 0x2FFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x30000, 0x3FFFD, makeData (BREAK_AL, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x3FFFE, 0x3FFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x4FFFE, 0x4FFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x5FFFE, 0x5FFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x6FFFE, 0x6FFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x7FFFE, 0x7FFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x8FFFE, 0x8FFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x9FFFE, 0x9FFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xAFFFE, 0xAFFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xBFFFE, 0xBFFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xCFFFE, 0xCFFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xDFFFE, 0xE0000, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xE0001, 0xE0001, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xE0002, 0xE001F, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xE0020, 0xE007F, makeData (BREAK_CM, WIDTH_N, GRAPHEME_Control, WORD_Format, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xE0080, 0xE00FF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xE0100, 0xE01EF, makeData (BREAK_CM, WIDTH_A, GRAPHEME_Extend, WORD_Default, CASE_Default, BIDI_NSM, BM_OFF));
			mRanges[i++] = new CharPropRange (0xE01F0, 0xE0FFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xEFFFE, 0xEFFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0xF0000, 0xFFFFD, makeData (BREAK_XX, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0xFFFFE, 0xFFFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			mRanges[i++] = new CharPropRange (0x100000, 0x10FFFD, makeData (BREAK_XX, WIDTH_A, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF));
			mRanges[i++] = new CharPropRange (0x10FFFE, 0x10FFFF, makeData (BREAK_AL, WIDTH_N, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_BN, BM_OFF));
			return i;
		}
	}

	private static final CharPropData mData = new CharPropData();

	private static class BIDIMirrorData {
		final int mChar;
		final int mMirror;

		BIDIMirrorData (int c, int mirror) {
			mChar = c;
			mMirror = mirror;
		}
	}

//----------------------------------------------------------------------
//
//		Pair table index map.  In order to keep the rows and
//		columns consistent with UAX14, this table maps our
//		BreakEnum enum value to a row or column number in the
//		table.	Note that true undexes start from one; zero being
//		reserved for classes that aren't represented in the table.
//
//----------------------------------------------------------------------

	private static int gnUAX14Map[] = {
			0,	// BREAK_AI
		12,		// BREAK_AL
		18,		// BREAK_B2
		16,		// BREAK_BA
		17,		// BREAK_BB
			0,	// BREAK_BK
			0,	// BREAK_CB
		 2,		// BREAK_CL
		20,		// BREAK_CM
			0,	// BREAK_CR
		 6,		// BREAK_EX
		 4,		// BREAK_GL
			0,	// BREAK_H2
			0,	// BREAK_H3
		15,		// BREAK_HY
		13,		// BREAK_ID
		14,		// BREAK_IN
		 8,		// BREAK_IS
			0,	// BREAK_JL
			0,	// BREAK_JT
			0,	// BREAK_JV
			0,	// BREAK_LF
			0,	// BREAK_NL
		 5,		// BREAK_NS
		11,		// BREAK_NU
		 1,		// BREAK_OP
		10,		// BREAK_PO
		 9,		// BREAK_PR
		 3,		// BREAK_QU
			0,	// BREAK_SA
			0,	// BREAK_SG
			0,	// BREAK_SP
		 7,		// BREAK_SY
		21,		// BREAK_WJ
			0,	// BREAK_XX
		19,		// BREAK_ZW
	};

//----------------------------------------------------------------------
//
//		Short-form definitions of the pair break rule names, to
//		keep the table on a single screen width.
//
//----------------------------------------------------------------------

	static final int BNO = BREAK_PROHIBIT;
	static final int BSP = BREAK_IF_SPACE;
	static final int BCM = BREAK_COMBINING_MARK;
	static final int BOK = BREAK_ALLOW;

//----------------------------------------------------------------------
//
//		Pair break rule table.	Rows are indexed by the "before"
//		class; columns by the "after" class.
//
//----------------------------------------------------------------------

	final static int geBreakRules[][] = {
		{BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO,BNO},
		{BOK,BNO,BSP,BSP,BNO,BNO,BNO,BNO,BOK,BSP,BOK,BOK,BOK,BOK,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BNO,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BNO,BNO,BNO},
		{BSP,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BNO,BNO,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BOK,BOK,BOK,BOK,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BOK,BOK,BOK,BOK,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BSP,BOK,BOK,BOK,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BSP,BOK,BOK,BOK,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BSP,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BSP,BSP,BSP,BOK,BSP,BSP,BOK,BOK,BNO,BNO,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BOK,BOK,BOK,BOK,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BSP,BSP,BSP,BOK,BSP,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BSP,BSP,BOK,BSP,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BSP,BOK,BOK,BOK,BSP,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BOK,BOK,BOK,BSP,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BSP,BOK,BOK,BOK,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BOK,BOK,BOK,BOK,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BSP,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BNO,BNO,BNO},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BOK,BOK,BOK,BOK,BSP,BSP,BOK,BNO,BNO,BCM,BNO},
		{BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BOK,BNO,BOK,BOK},
		{BOK,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BOK,BOK,BSP,BSP,BOK,BSP,BSP,BSP,BOK,BOK,BNO,BCM,BNO},
		{BSP,BNO,BSP,BSP,BSP,BNO,BNO,BNO,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BSP,BNO,BNO,BNO}
	};

//----------------------------------------------------------------------
//
//		Kinsoku-Shori Japanese line breaking restriction tables.
//		These provide further restrictions by specifying
//		characters that may not start or end a line.
//
//----------------------------------------------------------------------

	private static final int mgpcKSDisallowStart[] = {
		0x007d,
		0x2019,
		0x201d,
		0x3001,
		0x3002,
		0x3005,
		0x3009,
		0x300b,
		0x300d,
		0x300f,
		0x3011,
		0x3015,
		0x3041,
		0x3043,
		0x3045,
		0x3047,
		0x3049,
		0x3063,
		0x3083,
		0x3085,
		0x3087,
		0x308e,
		0x30a1,
		0x30a3,
		0x30a5,
		0x30a7,
		0x30a9,
		0x30c3,
		0x30e3,
		0x30e5,
		0x30e7,
		0x30ee,
		0x30f5,
		0x30f6,
		0x30fc,
		0xff01,
		0xff09,
		0xff0c,
		0xff0e,
		0xff1a,
		0xff1b,
		0xff1f,
		0xff3d
	};

	private final static int mgpcKSDisallowEnd[] = {
		0x007b,
		0x00a7,
		0x2018,
		0x201c,
		0x266f,
		0x3008,
		0x300a,
		0x300c,
		0x300e,
		0x3010,
		0x3012,
		0x3014,
		0xff04,
		0xff08,
		0xff20,
		0xff3b,
		0xffe0,
		0xffe1,
		0xffe5
	};


	public final static int makeData (int eBreak, int eWidth, int eGrapheme, int eWord, int eCase, int eBIDI, int eBM) {
		return eBreak | eWidth | eGrapheme | eWord | eCase | eBIDI | eBM;
	}

//----------------------------------------------------------------------
//
//		GetTextCharProperty - Get the line-breaking class for a given
//		character.
//
//----------------------------------------------------------------------
	public static int getCharProperty (int c) {
		if ((c >= 0xE000) && (c <= 0xF8FF)) {
			return makeData (BREAK_ID, WIDTH_W, GRAPHEME_Default, WORD_Default, CASE_Default, BIDI_L, BM_OFF);
		}

		int nLow = 0;
		int nHigh = mData.mRanges.length;

		while (nLow < nHigh) {
			int nSplit = (nLow + nHigh) >>> 1;
			int cTest = mData.mRanges[nSplit].mcStart;
			if (c < cTest) {
				nHigh = nSplit;
			} else if (c > cTest) {
				nLow = nSplit + 1;
			} else {
				nLow = nHigh = nSplit;
			}
		}

		if (mData.mRanges[nLow].mcStart > c) {
			if (nLow == 0) {
				return BREAK_AL;
			}
			nLow--;
		}

		if ((nLow >= mData.mRanges.length) || (c > mData.mRanges[nLow].mcEnd)) {
			return BREAK_AL;
		}

		return mData.mRanges[nLow].meBreak;
	}

//----------------------------------------------------------------------
//
//		GetPairRule() - Look up a rule, given the before and after
//		classes.
//
//----------------------------------------------------------------------
	public static int getPairRule (int eBefore, int eAfter) {
		int nRow = gnUAX14Map[getBreakClass (eBefore)];
		int nCol = gnUAX14Map[getBreakClass (eAfter)];

		if ((nRow == 0) || (nCol == 0)) {
			return BREAK_IF_SPACE;
		}

		return geBreakRules[nRow - 1][nCol - 1];
	}

	public static boolean kinsokuAllowStart (int c) {
		return ksLookup (c, mgpcKSDisallowStart);
	}

	public static boolean kinsokuAllowEnd (int c) {
		return ksLookup (c, mgpcKSDisallowEnd);
	}

	public static int getBreakClass (int nData) {
		return nData & BREAK_MASK;
	}

	public static int setBreakClass (int nData, int eBreak) {
		return (nData & ~BREAK_MASK) | eBreak;
	}

	public static int breakToIndex (int nData) {
		return getBreakClass (nData) >> BREAK_SHIFT;
	}

	public static int getWidthClass (int nData) {
		return nData & WIDTH_MASK;
	}

	public static int setWidthClass (int nData, int eWidth) {
		return (nData & ~WIDTH_MASK) | eWidth;
	}

	public static int widthToIndex (int nData) {
		return getWidthClass (nData) >> WIDTH_SHIFT;
	}

	public static int getGraphemeClass (int nData) {
		return nData & GRAPHEME_MASK;
	}

	public static int setGraphemeClass (int nData, int eGrapheme) {
		return (nData & ~GRAPHEME_MASK) | eGrapheme;
	}

	public static int graphemeToIndex (int nData) {
		return getGraphemeClass (nData) >> GRAPHEME_SHIFT;
	}

	public static int getWordClass (int nData) {
		return nData & WORD_MASK;
	}

	public static int setWordClass (int nData, int eWord) {
		return (nData & ~WORD_MASK) | eWord;
	}

	public static int wordToIndex (int nData) {
		return getWordClass (nData) >> WORD_SHIFT;
	}

	public static int getCaseClass (int nData) {
		return nData & CASE_MASK;
	}

	public static int setCaseClass (int nData, int eCase) {
		return (nData & ~CASE_MASK) | eCase;
	}

	public static int caseToIndex (int nData) {
		return getCaseClass (nData) >> CASE_SHIFT;
	}

	public static int getBIDIClass (int nData) {
		return nData & BIDI_MASK;
	}

	public static int setBIDIClass (int nData, int eBIDI) {
		return (nData & ~BIDI_MASK) | eBIDI;
	}

	public static int BIDIToIndex (int nData) {
		return getBIDIClass (nData) >> BIDI_SHIFT;
	}

	public static int getBIDIMirrorClass (int nData) {
		return nData & BM_MASK;
	}

	public static int setBIDIMirrorClass (int nData, int eBIDIMirror) {
		return (nData & ~BM_MASK) | eBIDIMirror;
	}

	public static int BIDIMirrorToIndex (int nData) {
		return getBIDIMirrorClass (nData) >> BM_SHIFT;
	}

	public static boolean isBIDIMirrored (int nData) {
		return getBIDIMirrorClass (nData) == BM_ON;
	}

	public static boolean isWordEdge (int eData) {
		switch (getWordClass (eData)) {
			case WORD_ALetter:
			case WORD_ExtendNumLet:
			case WORD_Format:
			case WORD_Katakana:
			case WORD_Numeric:
				return true;
		}

		return false;
	}

	public static int resolveBreakWidth (int eBefore, int eAfter, int eDefault) {
		int nNarrow = 0;
		int nWide = 0;

		switch (eBefore) {
			case WIDTH_Na:
			case WIDTH_H:
				nNarrow++;
				break;
			case WIDTH_W:
			case WIDTH_F:
				nWide++;
				break;
		}

		switch (eAfter) {
			case WIDTH_Na:
			case WIDTH_H:
				nNarrow++;
				break;
			case WIDTH_W:
			case WIDTH_F:
				nWide++;
				break;
		}

		if (nNarrow > nWide) {
			return BREAK_AL;
		} else if (nWide > nNarrow) {
			return BREAK_ID;
		} else {
			return eDefault;
		}
	}

	public static int resolveBreakWidth (int eBefore, int eAfter) {
		return resolveBreakWidth (eBefore, eAfter, BREAK_AI);
	}

	public static boolean isAmbiguousWidth (int eWidth) {
		return (eWidth == WIDTH_A) || (eWidth == WIDTH_N);
	}

	public static int getBIDIMirrorChar (int c) {
		int nLow = 0;
		int nHigh = mData.mBIDIMirrors.length;

		while (nLow < nHigh) {
			int nSplit = (nLow + nHigh) >>> 1;
			BIDIMirrorData data = mData.mBIDIMirrors[nSplit];
			int cTest = data.mChar;
			if (c < cTest) {
				nHigh = nSplit;
			} else if (c > cTest) {
				nLow = nSplit + 1;
			} else {
				return data.mMirror;
			}
		}
		return c;
	}

//----------------------------------------------------------------------
//
//		KSLookup() - Private helper function to look up a given
//		character, to see if it exists in a given Kinsoku-Shori
//		table.	Returns TRUE if _not_ found.
//
//----------------------------------------------------------------------
	private static boolean ksLookup (int c, int[] pcTable) {
		int nLow = 0;
		int nHigh = pcTable.length;

		while (nLow < nHigh) {
			int nSplit = (nLow + nHigh) >>> 1;
			int cTest = pcTable[nSplit];
			if (c < cTest) {
				nHigh = nSplit;
			} else if (c > cTest) {
				nLow = nSplit + 1;
			} else {
				return false; // found in table
			}
		}

		return true; // not found
	}
}
