package com.adobe.xfa.text;

import com.adobe.xfa.ut.UnitSpan;

/**
 * The null frame is a place-holder for frames not loaded
 * yet.  It allows content-based operations to detect missing
 * frames and cause them to be loaded.
 * @exclude from published api.
 */

public class TextNullFrame extends TextFrame {

// Null frame processing codes.
	public static final int MODE_LOAD	= 0;
	public static final int MODE_ALLOW	= 1;
	public static final int MODE_IGNORE	= 2;
	public static final int MODE_STOP	= 3;

	TextNullFrame () {
	}

	void Load () {
		TextSparseStream poStream = getStream();
		assert (poStream != null);
		poStream.replaceNullFrame (this);
	}

	public UnitSpan minWidth () {
		return UnitSpan.ZERO;
	}

	public UnitSpan minHeight () {
		return UnitSpan.ZERO;
	}

	public UnitSpan maxWidth () {
		return UnitSpan.ZERO;
	}

	public UnitSpan maxHeight () {
		return UnitSpan.ZERO;
	}

	public TextFrame cloneFrame () {
		assert (false);
		return null;
	}

	public TextNullFrame isNullFrame () {
		return this;
	}
}
