/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2008 Adobe Systems Incorporated
 * All Rights Reserved
 *
 * Notice: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa.wspolicy;

import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ut.FindBugsSuppress;

/**
 * @exclude from published api.
 */
public class CompoundAssertion extends Policy {

	CompoundAssertion (Document oDestDoc, Element oSrcNode, int eType) {
		super (oDestDoc, oSrcNode);
		setAssertionType (eType);

		for (Node oChild = oSrcNode.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
			if (oChild instanceof Element) {
				Policy poChildPolicy = Policy.loadPolicy (oDestDoc, (Element) oChild);
				if (poChildPolicy != null) {
					addPolicy (poChildPolicy);
				}
			}
		}
	}

	@FindBugsSuppress(code="ES")
	CompoundAssertion (Document oDestDoc, String aNameSpaceURI, String aLocalName) {
		super (oDestDoc, aNameSpaceURI, aLocalName);
		if (aLocalName == aWSP_POLICY || aLocalName == aWSP_ALL) {
			setAssertionType (Policy.WSP_ALL_ASSERTION);
		} else if (aLocalName == aWSP_EXACTLYONE) {
			setAssertionType (Policy.WSP_EXACTLY_ONE_ASSERTION);
		} else {
//			assert (false);
		}
	}

// Get a child assertion by name:
	@FindBugsSuppress(code="ES")
	public PrimitiveAssertion getPrimitiveAssertion (String aNameSpaceURI, String aLocalName, int nOccurrence /* = 0 */) {
		int nIndex = 0;
		for (Policy poChild = getFirstPolicyChild(); poChild != null; poChild = poChild.getNextPolicySibling()) {
			assert (poChild instanceof PrimitiveAssertion);
			if ((poChild.getNS() == aNameSpaceURI) && (poChild.getLocalName() == aLocalName)) {
				if (nIndex == nOccurrence) {
					return (PrimitiveAssertion) poChild;
				} else {
					nIndex++;
				}
			}
		}
		return null;
	}

// Create a new child assertion by name:
	public PrimitiveAssertion addPrimitiveAssertion (String aNameSpaceURI, String aLocalName) {
		Document oDestDoc = getDomNode().getOwnerDocument();

		PrimitiveAssertion poPrimitive = new PrimitiveAssertion (oDestDoc, aNameSpaceURI, aLocalName);
		addPolicy (poPrimitive);

		return poPrimitive;
	}

// Create a new choice (wsp:ExactlyOne) child
	public CompoundAssertion addChoicePolicy () {
		Document oDestDoc = getDomNode().getOwnerDocument();
		CompoundAssertion poChoice = new CompoundAssertion (oDestDoc, aWSP_NAMESPACE_URI, aWSP_EXACTLYONE);
		addPolicy (poChoice);
		return poChoice;
	}
}
