// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2012 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================
package com.adobe.xmp.core;

/**
 * A simple property represents a key/value pair and can be seen as a leaf of the tree (if not qualified).
 *
 */
public interface XMPSimple extends XMPNode
{
	/**
	 * Returns the value of this property
	 * @return the value of this property
	 */
	public String getValue();
	
	/**
	 * Set the value of this property
	 * 
	 * @param value Value of simple property to set
	 */
	public void setValue(String value);

	
	/**
	 * @return Returns whether is property is of type URI.
	 */
	public boolean isURI();
	
	
	/**
	 * Set URI type.
	 * 
	 * @param isURI Property is of type URI or not
	 */
	public void setURI(boolean isURI);
}
