// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model.rules;

import java.io.Serializable;

/**
 * A vocable is one item that is part of the OpenChoice and ClosedChoice rules.
 * It consists of an XMP value (that can be any Object and has to be interpreted
 * by the client) and a label for the UI.
 * Currently Vocables can be of the types
 * <ul>
 * 		<li>XMP Type --> Java Type</li>
 * 		<li>Text --> String</li>
 * 		<li>Integer --> Long</li>
 * 		<li>Real --> Double</li>
 * 		<li>Boolean --> Boolean</li>
 * 		<li>Date --> ISO8601 String</li>
 * 		<li>TODO: Fixed Array of Integers for some Exif special cases</li>
 * </uL>
 * 
 * @author Stefan Makswit
 */
public class Vocable implements Serializable
{
	/** Types of vocabulary */
	public enum Type
	{
		TEXT,
		INTEGER,
		REAL,
		BOOLEAN,
		DATE,
		ARRAY_OF_INTEGER 	// used for Exif special cases
	}
	
	private static final long serialVersionUID = 1L;
	/** The value of the vocable */
	private Object xmpValue;
	/** The human readable label of the vocable, e.g. to be used for drop down lists */
	private String label;

	
	/**
	 * Constructs a new Vocable.
	 *
	 * @param xmpValue the XMP value of the vocable
	 * @param label the display label of the vocable
	 */
	public Vocable(Object xmpValue, String label)
	{
		this.xmpValue = xmpValue;
		this.label = label;
	}

	
	/**
	 * @return Returns the XMP value
	 */
	public Object getXmpValue()
	{
		return xmpValue;
	}

	
	/**
	 * @return Returns the value.
	 */
	public String getLabel()
	{
		return label;
	}
}
