/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst;

import java.net.URI;

import com.day.cq.wcm.webservicesupport.Configuration;

public interface SitecatalystHttpClient {

    /**
     * Executes a SiteCatalyst API method via HTTP POST request. Authorization
     * headers are automatically generated and added to the request.
     * 
     * @param url API base URL
     * @param method API method name
     * @param data JSON data, will be submitted with MIME-Type 'application/json' and encoding 'UTF-8'.
     * @param company Company name
     * @param username User name
     * @param secret Webservice API secret
     * @return A JSON result String
     * @throws SitecatalystException {@link SitecatalystException}
     */
    public String execute(String url, String method, String data, String company, String username, String secret)
            throws SitecatalystException;

    /**
     * Executes a SiteCatalyst API method via HTTP POST request. Authorization
     * headers are automatically generated and added to the request.
     * 
     * @param method API method name
     * @param data JSON data, will be submitted with MIME-Type 'application/json' and encoding 'UTF-8'.
     * @param company Company name
     * @param username User name
     * @param secret Webservice API secret
     * @return A JSON result String
     * @throws SitecatalystException {@link SitecatalystException}
     */
    public String execute(String method, String data, String company, String username, String secret)
            throws SitecatalystException;
    
    /**
     * Executes a SiteCatalyst API method via HTTP POST request. Authorization
     * headers are automatically generated and added to the request. The
     * corresponding end point URL is evaluated according to the provided
     * <code>configuration</code>.
     * 
     * @param method API method name
     * @param data JSON data, will be submitted with MIME-Type 'application/json' and encoding 'UTF-8'.
     * @param configuration Service configuration
     * @return A JSON result String
     * @throws SitecatalystException {@link SitecatalystException}
     */
    String execute(String method, String data, Configuration configuration) throws SitecatalystException;

    /**
     * Sends data to SiteCatalyst Data Insertion API via HTTP POST request.
     * Authorization headers are automatically generated and added to the
     * request.
     * 
     * @param uri WebService end point URI
     * @param data String data, will be submitted with MIME-Type 'application/xml' and encoding 'UTF-8'.
     * @param configuration Service configuration
     * @return An XML result <code>String</code>
     * @throws SitecatalystException {@link SitecatalystException}
     */
    @Deprecated
    String execute(URI uri, String data, Configuration configuration) throws SitecatalystException;

    /**
     * Executes a SiteCatalyst API method via HTTP POST request. Authorization
     * headers for the SiteCatalyst proxy user are automatically generated and
     * added to the request.
     * 
     * @param method API method name
     * @param data JSON data, will be submitted with MIME-Type 'application/json' and encoding 'UTF-8'.
     * @return A JSON result String
     * @throws SitecatalystException {@link SitecatalystException}
     */
    String executeProxyUser(String method, String data) throws SitecatalystException;

}
