/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 *  __________________
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget;

import org.osgi.annotation.versioning.ProviderType;

import com.day.cq.wcm.webservicesupport.Configuration;

/**
 * The {@code TargetMediator} creates and keeps sync of reusable Adobe Target objects such as segments and offers
 */
@ProviderType
public interface TargetMediator extends TestandtargetCampaignMediator{

    /**
     * The JCR property that holds the Adobe Target id on the managed objects
     * @deprecated Use {@link TargetMediator#PN_PUBLISH_EXTERNAL_ID} or {@link TargetMediator#PN_AUTHOR_EXTERNAL_ID}
     * instead
     */
    String PN_EXTERNAL_ID = "externalId";


    /**
     * The JCR property that holds the Adobe Target id on the managed objects on the author instance.
     */
    String PN_AUTHOR_EXTERNAL_ID = "cq:authorExternalId";

    /**
     * The JCR property that holds the Adobe Target id on the managed objects on the author instance.
     */
    String PN_PUBLISH_EXTERNAL_ID = "cq:publishExternalId";

    /**
     * Synchronizes an offer with Adobe Target. After a successful synchronization this method returns the object id from Target
     * @param offerPath the repository path of the offer.
     * @param configuration the cloud services configuration containing the Adobe Target account details
     *
     * @return the object id from Target
     * @throws TestandtargetException {@link TestandtargetException}
     */
    long syncOffer(Configuration configuration, String offerPath) throws TestandtargetException;

    /**
     * Synchronizes an offer with Adobe Target. After a successful synchronization this method returns the object id from
     * Adobe Target.
     *
     * @param configuration the  Adobe Target cloud service configuration.
     * @param request a {@link SaveOfferRequest} object containing the offer's data - title and content.
     * @return the offerId generated by Adobe Target.
     * @throws TestandtargetException if any errors are encountered during synchronization
     */
    long syncOffer(Configuration configuration, SaveOfferRequest request) throws TestandtargetException;

    /**
     * Synchronizes a segment with Adobe Target
     * @param segmentPath Segment Path
     * @param configuration the cloud services configuration containing the Adobe Target account details
     *
     * @return the object id from Target.
     * @throws TestandtargetException {@link TestandtargetException}
     */
    long syncSegment(Configuration configuration, String segmentPath) throws TestandtargetException;

    /**
     * Deletes the Target campaign associated with the campaign at the provided path.
     * @param campaignPath the repository path of the campaign.
     * @throws TestandtargetException {@link TestandtargetException}
     */
    void deleteCampaign(String campaignPath) throws TestandtargetException;

    /**
     * Deletes the Target offer with the the provided id.
     * @param configuration the cloud services configuration containing the Adobe Target account details.
     * @param id the offer id.
     * @throws TestandtargetException {@link TestandtargetException}
     */
    void deleteOffer(Configuration configuration, long id) throws TestandtargetException;

}
