package com.day.cq.commons.predicate;

import com.day.cq.commons.jcr.JcrConstants;
import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

/**
 * Predicate used to filter nodes of type nt:unstructured.
 */
@Component(metatype = false)
@Service(Predicate.class)
@Properties({
        @Property(name = "predicate.name", value = "unstructured")
})
public class IsUnstructuredPredicate extends AbstractNodePredicate implements Predicate {

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if node is or extends nt:unstructured
     */
    public boolean evaluate(Node node) throws RepositoryException {
        return node.isNodeType(JcrConstants.NT_UNSTRUCTURED);
    }

}