/*
 *  ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.day.cq.dam.api.s7dam.set;

import java.util.List;
import java.util.Map;

import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.Nullable;

import com.day.cq.dynamicmedia.api.NotNullApi;

@NotNullApi
public interface SetHelper {

    /**
     * Create the new instance of Set and put it into JCR.
     * Attention: JCR changes are not persisted yet, you must save explicitly after calling this method!
     * After this method, {@link #updateSet} usually should be called to set the rest of necessary properties.
     *
     * @param parent       Resource of the Folder containing new Set
     * @param desiredName  desired name of the new Set (JCR node name), resulting name can differ to omit duplications
     * @param setType      type of the new Set (defined in S7damConstants)
     * @return             Resource pointing to the new valid Set, or throws RuntimeException
     */
    Resource createSet(Resource parent, String desiredName, String setType);

    /**
     * Update properties of existing Set in JCR.
     * Attention: JCR changes are not persisted yet, you must save explicitly after calling this method!
     *
     * @param setResource        Resource pointing to existing Set to update
     * @param title              (optional) user-facing title of the new Set, skipped updating if null
     * @param description        (optional) free-text description of the Set, skipped updating if null
     * @param manualThumbnail    (optional) JCR path for Asset used as thumbnail for the Set, skipped updating if null
     * @param contentProps       (optional) properties to add to "jcr:content" subnode, skipped if null
     * @param metadataProps      (optional) properties to add to "jcr:content/metadata" subnode, skipped if null
     * @param userdataProps      (optional) properties to add to "jcr:content/userdata" subnode, skipped if null
     * @param members            (optional) 2-D list of JCR paths of Set members to add, skipped updating if null;
     *                             Single-dimensional Set types (eg ImageSet) uses the first row only.
     *                             Existing members array is not deleted: if you need the full replace of members array,
     *                               you have to clear members with {@link #clearMembers(Resource)} before calling
     *                               this method, and set non-null "members" param (can be empty List for empty Set)
     * @param swatches           (optional) contains the map of swatch images associated to Set members:
     *                             key = path of member Asset, value = path of Asset used as swatch for that member
     * @param generateThumbnail  after updating, generate thumbnail Rendition from first few members, or from user-
     *                             selected Asset in {@code manualThumbnail} property.
     */
    void updateSet(Resource setResource,
                   @Nullable String title,
                   @Nullable String description,
                   @Nullable String manualThumbnail,
                   @Nullable Map<String, Object> contentProps,
                   @Nullable Map<String, Object> metadataProps,
                   @Nullable Map<String, String> userdataProps,
                   @Nullable List<List<String>> members,
                   @Nullable Map<String, String> swatches,
                   boolean generateThumbnail);

    /**
     * Delete all member relations from the Set.
     *
     * @param setResource   Resource pointing to existing Set to update
     */
    void clearMembers(Resource setResource);

}
