/*************************************************************************
 * ADOBE CONFIDENTIAL __________________
 * <p>
 * Copyright 2016 Adobe Systems Incorporated All Rights Reserved.
 * <p>
 * NOTICE:  All information contained herein is, and remains the property of Adobe Systems Incorporated and its suppliers, if any.  The
 * intellectual and technical concepts contained herein are proprietary to Adobe Systems Incorporated and its suppliers and are protected by
 * trade secret or copyright law. Dissemination of this information or reproduction of this material is strictly forbidden unless prior
 * written permission is obtained from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.commons.util;

import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.jobs.Job;

/**
 * Monitors workflow steps during asset updates.
 *
 * This service can be used by workflow processes and jobs involved in Asset Update handling to facilitate
 * MBean supervision.
 */
public interface AssetUpdateMonitor {

    /**
     * A process in an asset update workflow starts working on an item.
     *
     * @param item      the workflow item being started
     * @param resolver  the resolver to use for lookups
     * @param process   the process running instance
     * @return an object representing the update supervision
     */
    AssetUpdate startUpdate(WorkItem item, ResourceResolver resolver, Object process);

    /**
     * A Sling job in an asset update workflow starts working.
     *
     * @param assetPath  the path of the asset being worked on
     * @param resolver   the resolver to use for lookups
     * @param job        the job currently starting
     * @param processor  the instance processing the job
     * @return an object representing the update supervision
     */
    AssetUpdate startJobUpdate(String assetPath, ResourceResolver resolver, Job job, Object processor);

}
