/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.api;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

/**
 * Helps working with campaign resources. Campaign resources can be adapted to
 * this.
 * 
 */
public interface Campaign {
	
	public static final String RESOURCE_TYPE = "cq/personalization/components/campaignpage";
	
	public Resource getResource();
	
	public String getTitle();
	
	/**
	 * 
	 * @return <code>null</code> if this is a campaign that doesn't sit underneath
	 * a brand node (checks the resourcetype of the parent).
	 */
	public Brand getBrand();
	
	/**
	 * 'title (brandname)'.
	 * @return the title and a possible brandname in parens. 
	 */
	public String getLongTitle();

	/**
	 * Get the properties map from the jcr:content node.
	 * @return
	 */
	public ValueMap getProps();
}
