/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.preferences;

import com.day.cq.security.NoSuchAuthorizableException;

/**
 * Allows access and removal of user specific settings.
 *
 * @see Preferences
 * @deprecated cq 5.5
 */
public interface PreferencesService {

    /**
     * Access the Preferences of the User which session is given as argument
     *
     * @return Preferences of User
     */
    Preferences get();

    /**
     * Acquire the Preferences fo a given authorizable.<br>
     * If access rights are sufficient,
     * implementations have to return a Preferences object.
     *
     * @param authorizableId the Id of the Authorizable to access the Preferences for
     * @return Preferences
     * @throws NoSuchAuthorizableException if there is no Authorizable with the given ID;
     */
    Preferences get(String authorizableId) throws NoSuchAuthorizableException;

    /**
     * Remove all Preferences for the User of the given session.
     *
     * @return if the Preferences existed and have been removed
     */
    boolean remove();

    /**
     * Remove all Preferences of the Authorizable the given ID identifies.
     * Take the Privileges of the session given for this operation
     *
     * @param authorizableId to remove the Preferences for
     * @return true if the Preferences existed and have been removed
     * @throws NoSuchAuthorizableException if the given ID does not point to an existing Authorizable
     */
    boolean remove(String authorizableId) throws NoSuchAuthorizableException;
}
