/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.replication;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import java.util.Map;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

/**
 * A provider for {@link ReplicationStatus}
 */
@ProviderType
public interface ReplicationStatusProvider {

    /**
     * Returns a batch replication status for a number of resources, in the form of a map whose keys are paths and values
     * are related replication statuses.
     * This method is expected to be used with a bunch of resources, when needing retrieval of replication status for a
     * single resource please use #getReplicationStatus(Resource).
     *
     * @param resources the resource to obtain the statuses for
     * @return the batch replication status as a map of path to status
     */
    @Nonnull
    Map<String, ReplicationStatus> getBatchReplicationStatus(@Nonnull Resource... resources);

    /**
     * Returns a replication status for the given resource
     * @param resource the resource to obtain the status for
     * @return the replication status or <code>null</code> if not available.
     */
    @CheckForNull
    ReplicationStatus getReplicationStatus(@Nonnull Resource resource);

    /**
     * Returns a replication status for the node at a given path
     * @param session the session used to access the node at the given path
     * @param path path to check
     * @return the replication status or <code>null</code> if not available.
     * @throws RepositoryException if retrieval of the related node fails
     */
    @CheckForNull
    ReplicationStatus getReplicationStatus(@Nonnull Session session, @Nonnull String path) throws RepositoryException;
}
