/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.linkchecker;

import java.net.URI;

/**
 * Encapsulates all information of a link.
 *
 * @since 5.3
 */
public interface Link {

    /**
     * Returns the href as passed in the constructor
     * @return the href.
     */
    String getHref();

    /**
     * Returns the URI or <code>null</code>.
     * @return the URI
     */
    URI getUri();

    /**
     * Returns the context relative URI or <code>null</code>
     * @return the URI
     */
    URI getRelUri();

    /**
     * Returns the link validity.
     * @return the validity
     */
    LinkValidity getValidity();

    /**
     * Checks if this is a special link (like mailto: javascript: etc)
     * @return <code>true</code> if this is a special link
     */
    boolean isSpecial();

    /**
     * Checks if this is a context relative link.
     * @return <code>true</code> if this is a context relative link.
     */
    boolean isContextRelative();

}