/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api;

import com.day.cq.commons.jcr.JcrConstants;

/**
 * Constants for jcr names used in cq. conventions:
 * <ul>
 * <li>NT_ prefix stands for "node type"
 * <li>NN_ prefix stands for "node name"
 * <li>PN_ prefix stands for "property name"
 * <li>Constants all uppercase
 * <li>"replace" intercaps by underscores. eg: PN_PAGE_TITLE = "PageTitle"
 * </ul>
 */
public interface NameConstants {

    static final String NT_PAGE = "cq:Page";
    static final String NT_PSEUDO_PAGE = "cq:PseudoPage";
    static final String NT_TEMPLATE = "cq:Template";
    static final String NT_COMPONENT = "cq:Component";
    static final String NT_EDIT_CONFIG = "cq:EditConfig";

    // component
    static final String NN_CONTENT = JcrConstants.JCR_CONTENT;
    static final String NN_DIALOG = "dialog";
    static final String PN_DIALOG_PATH = "dialogPath";
    static final String NN_DESIGN_DIALOG = "design_dialog";
    static final String PN_DESIGN_DIALOG_PATH = "designDialogPath";
    static final String NN_EDIT_CONFIG = "cq:editConfig";
    static final String NN_CHILD_EDIT_CONFIG = "cq:childEditConfig";
    static final String NN_ICON_PNG = "icon.png";
    static final String NN_THUMBNAIL_PNG = "thumbnail.png";
    static final String PN_CELL_NAME = "cq:cellName";
    static final String PN_IS_CONTAINER = "cq:isContainer";
    static final String PN_NO_DECORATION = "cq:noDecoration";
    static final String NN_HTML_TAG = "cq:htmlTag";
    static final String PN_ALLOWED_PATHS = "allowedPaths";
    static final String PN_ALLOWED_CHILDREN = "allowedChildren";
    static final String PN_ALLOWED_PARENTS = "allowedParents";
    static final String PN_COMPONENT_GROUP = "componentGroup";
    static final String PN_RANKING = "ranking";
    static final String PN_SITE_PATH = "sitePath";
    static final String NN_PARAMS = "params";
    static final String NN_VIRTUAL = "virtual";
    static final String PN_TEMPLATE_PATH = "cq:templatePath";
    static final String NN_TEMPLATE = "cq:template";
    static final String PN_TAG_NAME = "cq:tagName";
    static final String NN_INFO_PROVIDERS = "cq:infoProviders";
    static final String PN_CLASS_NAME = "className";
    /** @since 6.1 */
    static final String PN_DELETED = "deleted";
    static final String PN_DELETED_BY = "deletedBy";

    /**
     * The node will contain all necessary information
     * needed to support responsive authoring functionality
     * like responsive grid, media query breakpoints etc
     * @since 6.1
     */
    static final String NN_RESPONSIVE_CONFIG = "cq:responsive";

    /**
     * The node will contain all authoring related features
     * which DO NOT have impact on the rendering or logic of component
     * but on the behavior of the authoring UI
     * @since 6.1
     */
    static final String NN_AUTHORING_CONFIG = "cq:authoring";


    /** @since 5.6 */
    static final String PN_DISABLE_TARGETING = "cq:disableTargeting";

    // editing
    static final String PN_LAYOUT = "cq:layout";
    static final String PN_DIALOG_MODE = "cq:dialogMode";
    /** @since 5.3 */
    static final String NN_INPLACE_EDITING = "cq:inplaceEditing";
    static final String PN_EMPTY_TEXT = "cq:emptyText";
    static final String PN_ACTIONS = "cq:actions";
    static final String NN_ACTION_CONFIGS = "cq:actionConfigs";
    static final String NN_FORM_PARAMETERS = "cq:formParameters";
    static final String NN_DROP_TARGETS = "cq:dropTargets";
    static final String NN_LISTENERS = "cq:listeners";
    static final String PN_DT_NAME = "propertyName";
    static final String PN_DT_ACCEPT = "accept";
    static final String PN_DT_GROUPS = "groups";
    static final String NN_DT_PARAMETERS = "parameters";
    /** @since 5.4 */
    static final String PN_INHERIT = "cq:inherit";
    /** @since 6.3 */
    static final String PN_ORDER = "order";
    /** @deprecated use <code>order</code> instead */
    static final String PN_ORDER_BEFORE = "orderBefore";

    /**
     * This property can contain the location of a redirect target
     * @since 1.26.0
     */
    static final String PN_REDIRECT_TARGET = "cq:redirectTarget";


    // designer
    static final String PN_DESIGN_PATH = "cq:designPath";

    // versioning
    static final String PN_PARENT_PATH = "cq:parentPath";
    static final String PN_NAME = "cq:name";
    static final String PN_CHILDREN_ORDER = "cq:childrenOrder";
    static final String PN_SIBLING_ORDER = "cq:siblingOrder";
    static final String PN_VERSION_COMMENT = "cq:versionComment";

    // misc
    static final String PN_TITLE = JcrConstants.JCR_TITLE;
    static final String PN_SHORT_TITLE = "shortTitle";
    static final String PN_PAGE_TITLE = "pageTitle";
    static final String PN_TEMPLATE = "cq:template";
    static final String PN_NAV_TITLE = "navTitle";
    static final String PN_DESCRIPTION = JcrConstants.JCR_DESCRIPTION;
    static final String PN_HIDE_IN_NAV = "hideInNav";
    static final String PN_LAST_MOD = JcrConstants.JCR_LASTMODIFIED;
    static final String PN_LAST_MOD_BY = JcrConstants.JCR_LAST_MODIFIED_BY;
    static final String PN_CREATED = JcrConstants.JCR_CREATED;
    static final String PN_CREATED_BY = JcrConstants.JCR_CREATED_BY;
    static final String PN_ON_TIME = "onTime";
    static final String PN_OFF_TIME = "offTime";
    static final String PN_PAGE_LAST_MOD = "cq:lastModified";
    static final String PN_PAGE_LAST_MOD_BY = "cq:lastModifiedBy";
    static final String PN_PAGE_LAST_REPLICATED = "cq:lastReplicated";
    static final String PN_PAGE_LAST_REPLICATED_BY = "cq:lastReplicatedBy";
    static final String PN_PAGE_LAST_REPLICATION_ACTION= "cq:lastReplicationAction";
    static final String PN_TAGS = "cq:tags";
    static final String PN_DEFAULT_VIEW = "cq:defaultView";
    static final String PN_SLING_VANITY_PATH = "sling:vanityPath";

    /** @since 5.3 */
    static final String PN_ALLOWED_TEMPLATES = "cq:allowedTemplates";

    // deprecated

    /** @deprecated */
    static final String PN_VANITY_URL = "vanityUrl";

    /** @deprecated */
    static final String PN_PAGE_LAST_PUBLISHED = "cq:lastPublished";

    /** @deprecated */
    static final String PN_PAGE_LAST_PUBLISHED_BY = "cq:lastPublishedBy";

    /** @deprecated */
    static final String PN_PAGE_LAST_REPLICATION_STATUS = "cq:lastReplicationStatus";

}