/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api.components;

import java.util.Map;

import com.day.cq.commons.JSONItem;

/**
 * Specifies a drop target as configured in the edit config.
 */
public interface DropTarget extends JSONItem {

    /**
     * prefix for the CSS Class
     */
    final String CSS_CLASS_PREFIX = "cq-dd-";

    /**
     * Returns the name of this drop target
     * @return drop target name
     */
    String getName();

    /**
     * Returns the id for the drop target element. this is currently the same
     * as the name, prefixed with the {@link #CSS_CLASS_PREFIX}
     * 
     * @return drop target id
     */
    String getId();

    /**
     * Returns the DD groups for this target
     * @return the DD groups.
     */
    String[] getGroups();

    /**
     * Returns the mime-type accept patterns
     * @return the accept patterns
     */
    String[] getAccept();

    /**
     * Returns the property name to use for this drop target.
     * @return the property name.
     */
    String getPropertyName();

    /**
     * Returns a map of additional parameters to be set on the target node
     * @return a map of additional parameters.
     */
    Map<String, String> getParameters();
}