/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 * **************************************************************************/

package com.day.cq.wcm.command.api;

import org.osgi.annotation.versioning.ProviderType;
import javax.annotation.Nonnull;

/**
 * factory interface to create the required {@link CommandBuilder}
 */
@ProviderType
public interface CommandBuilderFactory {

    /**
     * creates the required {@code CommandBuilder}
     *
     * @param clazz class name of the required command builder
     * @return the required {@code CommandBuilder}
     * @throws IllegalArgumentException if the clazz argument is unsupported
     */
    @Nonnull
    <T extends CommandBuilder> T createCommandBuilder(@Nonnull Class<T> clazz) throws IllegalArgumentException;

}
