/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.mobile.api.device.capability;

/**
 * The <code>DeviceCapability</code> interface specifies the capability of a mobile device as used by the {@link
 * com.day.cq.wcm.mobile.api.device.DeviceGroup}.
 *
 * @since CQ 5.4.0
 */
public interface DeviceCapability {

    /**
     * @deprecated will be removed and privatized, as capabilities are now available via {@link
     *             com.day.cq.wcm.mobile.api.device.DeviceMapper#getCapabilities()}
     */
    static final DeviceCapability CAPABILITY_DEVICEROTATION = new DeviceRotation();

    /**
     * @deprecated will be removed and privatized, as capabilities are now available via {@link
     *             com.day.cq.wcm.mobile.api.device.DeviceMapper#getCapabilities()}
     */
    static final DeviceCapability CAPABILITY_CSS = new CSS();

    /**
     * @deprecated will be removed and privatized, as capabilities are now available via {@link
     *             com.day.cq.wcm.mobile.api.device.DeviceMapper#getCapabilities()}
     */
    static final DeviceCapability CAPABILITY_IMAGES = new Images();

    /**
     * @deprecated will be removed and privatized, as capabilities are now available via {@link
     *             com.day.cq.wcm.mobile.api.device.DeviceMapper#getCapabilities()}
     */
    static final DeviceCapability CAPABILITY_JAVASCRIPT = new JavaScript();

    /**
     * Return the name of this device capability.
     *
     * @return A <code>String</code> representing the name of this device capability.
     */
    String getName();

    /**
     * Returns a human readable title of this device capability.
     *
     * @return A <code>String</code> representing the title of this device capability.
     */
    String getTitle();

    /**
     * Returns a description of this device capability.
     *
     * @return A <code>String</code> representing the description.
     */
    String getDescription();

    /**
     * Returns an array of WURFL database value keys that this capability is based on.
     *
     * @return A <code>String</code> array representing the keys.
     */
    String[] getKeys();
}
