/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.workflow.process;

import com.adobe.granite.workflow.collection.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import java.util.ArrayList;
import java.util.List;

public class ResourceCollectionHelper {

    private static final Logger log = LoggerFactory.getLogger(ResourceCollectionHelper.class);

    private static final String[] ALLOWED_NODE_PRIMARY_AND_RESOURCE_TYPES = {"cq:Page", "dam:Asset",
            "wcm/core/components/policy/policy",
            "cq/tagging/components/tag"};

    public ResourceCollectionHelper(){}

    public static List<String> getPaths(String path, List<ResourceCollection> rcCollections) {
        List<String> paths = new ArrayList<String>();
        if (rcCollections == null || rcCollections.size() == 0) {
            paths.add(path);
        } else {
            log.debug("ResourceCollections detected");
            for (ResourceCollection rcCollection : rcCollections) {
                // this is a resource collection. the collection itself is not
                // replicated. only its members
                try {
                    List<Node> members = rcCollection.list(ALLOWED_NODE_PRIMARY_AND_RESOURCE_TYPES);
                    for (Node member : members) {
                        String mPath = member.getPath();
                        paths.add(mPath);
                    }
                } catch (RepositoryException re) {
                    log.error("Cannot build path list out of the resource collection " + rcCollection.getPath());
                }
            }
        }
        return paths;
    }
}
