/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.filter;

import javax.jcr.RepositoryException;

import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;

import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.filter.WorkItemFilter;

public class InboxFilter implements WorkItemFilter {
    private String path;
    private String model;
    private String step;
    private String authorizableType;
    private String assignee;

    private UserManager usrMgr;

    public InboxFilter(UserManager usrMgr, String path, String model,
            String step, String authorizableType, String assignee) {
        this(usrMgr);

        this.path = path;
        this.model = model;
        this.step = step;
        this.authorizableType = authorizableType;
        this.assignee = assignee;
    }

    public InboxFilter(UserManager usrMgr) {
        this.usrMgr = usrMgr;
    }

    public boolean doInclude(WorkItem item) {
        boolean include = true;

        // workitems without assignee are anonymous system
        // workitems and don't show up in the inbox
        if (item.getCurrentAssignee()==null) {
            return false;
        }

        if (path != null) {
            if (item.getWorkflowData().getPayloadType().equals("JCR_PATH")
                    && !item.getWorkflowData().getPayload().toString()
                            .startsWith(path)) {
                include = false;
            }
        }
        if (include && model != null) {
            if (!item.getWorkflow().getWorkflowModel().getId().equals(model)) {
                include = false;
            }
        }
        if (include && step != null) {
            if (!item.getNode().getId().equals(step)) {
                include = false;
            }
        }
        if (include && authorizableType != null) {
            String assignee = item.getCurrentAssignee();

            Authorizable auth = null;
            try {
                if (assignee.startsWith("/")) {
                    auth = usrMgr.getAuthorizableByPath(assignee);
                } else {
                    auth = usrMgr.getAuthorizable(assignee);
                }
            } catch (RepositoryException e) {
                auth = null;
            }

            if (auth != null) {
                if (authorizableType.equals("user") && auth.isGroup()) {
                    include = false;
                } else if (authorizableType.equals("group") && !auth.isGroup()) {
                    include = false;
                }
            } else {
                include = false;
            }
        }
        if (include && assignee != null) {
            if (!item.getCurrentAssignee().equals(assignee)) {
                include = false;
            }
        }
        return include;
    }

    /**
     * @return the path
     */
    public String getPath() {
        return path;
    }

    /**
     * @param path
     *            the path to set
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * @return the model
     */
    public String getModel() {
        return model;
    }

    /**
     * @param model
     *            the model to set
     */
    public void setModel(String model) {
        this.model = model;
    }

    /**
     * @return the step
     */
    public String getStep() {
        return step;
    }

    /**
     * @param step
     *            the step to set
     */
    public void setStep(String step) {
        this.step = step;
    }

    /**
     * @return the authorizableType
     */
    public String getAuthorizableType() {
        return authorizableType;
    }

    /**
     * @param authorizableType
     *            the authorizableType to set
     */
    public void setAuthorizableType(String authorizableType) {
        this.authorizableType = authorizableType;
    }

    /**
     * @return the assignee
     */
    public String getAssignee() {
        return assignee;
    }

    /**
     * @param assignee
     *            the assignee to set
     */
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }
}
