/*##############################################################################
 # ADOBE CONFIDENTIAL
 # ___________________
 #
 #  Copyright 2020 Adobe
 #  All Rights Reserved.
 #
 # NOTICE: All information contained herein is, and remains
 # the property of Adobe and its suppliers, if any. The intellectual
 # and technical concepts contained herein are proprietary to Adobe
 # and its suppliers and are protected by all applicable intellectual
 # property laws, including trade secret and copyright laws.
 # Dissemination of this information or reproduction of this material
 # is strictly forbidden unless prior written permission is obtained
 # from Adobe.
 #############################################################################*/
package com.day.cq.xss.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

import com.day.cq.xss.ProtectionContext;
import com.day.cq.xss.XSSProtectionService;

/**
 * This class implements a tag that can be used to prevent its body content from containing
 * any XSS stuff.
 * <p>
 * The policy to be used may be specified using the policy attribute.
 * @deprecated
 */
@Deprecated
public class ProtectBody extends BodyTagSupport {

    /**
     * Path to policy file to use; <code>null</code>, if the default policy has to be used
     */
    private String policy;

    /**
     * The protection context to use
     */
    private String context;

    /**
     * Get the path to the policy to be used.
     *
     * @return Path to policy file to use; <code>null</code>, if the default policy has to
     *         be used
     */
    public String getPolicy() {
        return policy;
    }

    /**
     * Set the path to the policy to be used.
     *
     * @param policy Path to policy file to use; <code>null</code>, if the default policy
     *               has to be used
     */
    public void setPolicy(String policy) {
        this.policy = policy;
    }

    /**
     * Get the protection context.
     *
     * @return Attribute name
     */
    public String getContext() {
        return this.context;
    }

    /**
     * Set the protection context.
     *
     * @param context The protection context
     */
    public void setContext(String context) {
        this.context = context;
    }

    protected ProtectionContext getProtectionContext() throws JspException {
        String contextName = (this.context != null ? this.context
                : ProtectionContext.HTML_HTML_CONTENT.getName());
        if (contextName == null) {
            contextName = ProtectionContext.HTML_HTML_CONTENT.getName();
        }
        ProtectionContext pc = ProtectionContext.fromName(contextName);
        if (pc == null) {
            throw new JspException("Invalid protection context: " + contextName);
        }
        return pc;
    }

    /**
     * Executes the XSS removal.
     */
    @Override
    public int doAfterBody() throws JspException {
        try {
            XSSProtectionService service = Utils.getService(this.pageContext);
            if (service != null) {
                BodyContent bc = this.getBodyContent();
                String src = bc.getString();
                bc.clearBody();
                bc.getEnclosingWriter().println(service.protectForContext(
                        getProtectionContext(), src, getPolicy()));
            }
        } catch (Exception e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

}
