/*************************************************************************
* ADOBE CONFIDENTIAL
* __________________
*
* Copyright 2011 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.jmx.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specify what actual class is used to represent
 * {@link javax.management.openmbean.CompositeData} or
 * {@link javax.management.openmbean.TabularData}, which will be used to
 * generate the corresponding {@link javax.management.openmbean.CompositeType}
 * or {@link javax.management.openmbean.TabularType}.
 */
@Target({ ElementType.METHOD, ElementType.PARAMETER })
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface OpenTypeInfo {
    /**
     * Returns the actual class to represent
     * {@link javax.management.openmbean.CompositeData} or
     * {@link javax.management.openmbean.TabularData}.
     * @return the actual class to represent
     */
    Class<?> value();
}
