/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2006 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.internal.io.stream;

import java.io.IOException;
import java.io.InputStream;

/*package protected*/ class InputStreamImpl extends InputStream
{
	InputByteStream ibs;

	// The "marked" position for use in mark() and reset().
	protected long mark = 0;


	/**
	 * The <code>InputByteStream</code> passed in to this class belongs to it and the caller
	 * must <b>never</b> use it again.  This class will close it when it is finished with it.
	 */
	public InputStreamImpl(InputByteStream ibs)
	{
		super();
		this.ibs = ibs;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#available()
	 */
	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public int available()
	throws IOException
	{
		return (int) (this.ibs.bytesAvailable() <= Integer.MAX_VALUE ? this.ibs.bytesAvailable() : Integer.MAX_VALUE);
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#mark(int)
	 */
	/**
	 * Only for internal engineering use. This api can change without notice.
	 * Marks the current position in the stream.
	 * readLimit parameter being passed doesn't have any sense here.
	 */
	public void mark(int readLimit)
	{
		try {
			mark = ibs.getPosition();
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#markSupported()
	 */
	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public boolean markSupported()
	{
		return true;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#reset()
	 */
	/**
	 * Only for internal engineering use. This api can change without notice.
	 * Resets the stream to the position when mark() was called.
	 * if mark() was not called since the stream was created then it resets to start of the file. 
	 */
	public void reset()
	throws IOException
	{
		this.ibs.seek(this.mark);
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#skip(long)
	 */
	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public long skip(long n)
	throws IOException
	{
		n = Math.min(n, this.ibs.length());
		this.ibs.seek(this.ibs.getPosition() + n);
		return n;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#close()
	 */
	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public void close()
	throws IOException
	{
		if (this.ibs != null)
		{
			this.ibs.close();
			this.ibs = null;
		}
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#read()
	 */
	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public int read()
	throws IOException
	{
		return ibs.read();
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#read(byte[], int, int)
	 */
	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public int read(byte[] b, int offset, int length)
	throws IOException
	{
		return ibs.read(b, offset, length);
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#read(byte[])
	 */
	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public int read(byte[] b)
	throws IOException
	{
		return this.read(b, 0, b.length);
	}
}
