/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.Schema;
import com.adobe.xfa.template.TemplateSchema;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ChildReln;

/**
 * @exclude from public api.
 */
public class FormSchema extends TemplateSchema {
	
	public FormSchema() {		
		initSchema();
	}
	
	protected void initSchema() {
		
		super.initSchema();
	
		// form  same as template.
		putElement(  XFA.FORMTAG, XFA.SUBFORMTAG,	ChildReln.getZeroOrMore(), 0, Schema.XFAAVAILABILITY_ALL, 0);
		putElement(  XFA.FORMTAG, XFA.PROTOTAG,		ChildReln.getZeroOrMore(), 0, Schema.XFAAVAILABILITY_ALL, 0);
		putElement(  XFA.FORMTAG, XFA.DESCTAG,		ChildReln.getZeroOrOne(),  0, Schema.XFAAVAILABILITY_ALL, 0);
		putElement(  XFA.FORMTAG, XFA.EXTRASTAG,	ChildReln.getZeroOrOne(),  0, Schema.XFAAVAILABILITY_ALL, 0);
		putElement(  XFA.FORMTAG, XFA.DSIGDATATAG,	ChildReln.getZeroOrMore(), 0, Schema.XFAAVAILABILITY_ALL, 0);
		putAttribute(XFA.FORMTAG, XFA.CHECKSUMTAG, null, 0, Schema.XFAAVAILABILITY_ALL, 0);
		
		// subform  add instancemanager
		putElement(XFA.SUBFORMTAG, XFA.INSTANCEMANAGERTAG,	ChildReln.getZeroOrMore(), 0, Schema.XFAAVAILABILITY_ALL, 0);

		// subformSet  add instancemanager
		putElement(XFA.SUBFORMSETTAG, XFA.INSTANCEMANAGERTAG, ChildReln.getZeroOrMore(), 0, Schema.XFAAVAILABILITY_ALL, 0);

		// pageArea  add instancemanager
		putElement(XFA.PAGEAREATAG, XFA.INSTANCEMANAGERTAG, ChildReln.getZeroOrMore(), 0, Schema.XFAAVAILABILITY_ALL, 0);

		// you can have more than one pageArea in the form dom.
		// watson bug 1347645  
		putElement(XFA.SUBFORMTAG, XFA.PAGESETTAG, ChildReln.getZeroOrMore(), 0, Schema.XFAAVAILABILITY_ALL, 0);

		// instancemanager
		putAttribute(XFA.INSTANCEMANAGERTAG, XFA.NAMETAG, new StringAttr(XFA.NAME, ""), 0, Schema.XFAAVAILABILITY_ALL, 0);
		putElement(  XFA.INSTANCEMANAGERTAG, XFA.OCCURTAG,	ChildReln.getZeroOrOne(), 0, Schema.XFAAVAILABILITY_ALL, 0);
	}
	
	protected Element newElement(int eTag, Element parent, Node prevSibling) {
		switch (eTag) {
		case XFA.FIELDTAG: return new com.adobe.xfa.form.FormField(parent, prevSibling);
		case XFA.SUBFORMTAG: return new com.adobe.xfa.form.FormSubform(parent, prevSibling);
		case XFA.EXCLGROUPTAG: return new com.adobe.xfa.form.FormExclGroup(parent, prevSibling);
		case XFA.SUBFORMSETTAG: return new com.adobe.xfa.form.FormSubformSet(parent, prevSibling);
		case XFA.INSTANCEMANAGERTAG: return new com.adobe.xfa.form.FormInstanceManager(parent, prevSibling);
		case XFA.MANIFESTTAG: return new com.adobe.xfa.form.FormManifest(parent, prevSibling);
		}
		
		return super.newElement(eTag, parent, prevSibling);
	}
		
}
