/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.collection.util;

import com.day.cq.workflow.WorkflowSession;

/**
 * Interface for a set of workflow entities that can be retrieved via
 * <code>{@link WorkflowSession}</code>.
 */
public interface ResultSet<T> {
    /**
     * Returns the items contained in this result set.
     * 
     * @return The items contained in this result set.
     */
    T[] getItems();

    /**
     * Returns the total number of results available.
     * 
     * @return The total number of results available.
     */
    long getTotalSize();
}
