/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.rest;

/**
 * {@code Constants} provides various constants.
 */
public final class Constants {

    private Constants() {

    }

    /**
     * Default property name for properties of type {@link java.io.InputStream}.
     */
    public static final String PN_FILE = "file";

    /**
     * Property name for the actual stream for properties of type {@link java.io.InputStream}.
     */
    public static final String PN_FILE_INPUT = "fileinput";

    /**
     * Property name for the mimetype for properties of type {@link java.io.InputStream}.
     */
    public static final String PN_FILE_MIMETYPE = "mimetype";

    /**
     * Property name for the file name for properties of type {@link java.io.InputStream}.
     */
    public static final String PN_FILE_NAME = "name";
 
    /**
     * Postfix string appended to property keys with values of type
     * {@link java.io.InputStream}.
     * 
     * @deprecated has been replaced by {@link #PN_FILE_NAME}
     */
    public static final String PN_FILENAME_POSTFIX = "_filename";

    /**
     * Postfix string appended to property names with values of type
     * {@link java.io.InputStream}.
     * 
     * @deprecated has been replaced by {@link #PN_FILE_MIMETYPE}
     */
    public static final String PN_CONTENTTYPE_POSTFIX = "_contentype";

    /**
     * Limit request parameter name.
     */
    public static final String PARAM_LIMIT = "limit";

    /**
     * Offset request parameter name.
     */
    public static final String PARAM_OFFSET = "offset";

    /**
     * Show all properties request parameter name.
     */
    public static final String PARAM_SHOWALLPROPERTIES = "showAllProperties";

    /**
     * Show property request parameter name.
     */
    public static final String PARAM_SHOWPROPERTY = "showProperty";

    /**
     * Content type application/x-www-form-urlencoded
     */
    public static final String CT_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";

    /**
     * Content type multipart/form-data
     */
    public static final String CT_MULTIPART_FORMDATA = "multipart/form-data";

    /**
     * Content type application/json
     */
    public static final String CT_JSON = "application/json";

    /**
     * Content type application/vnd.siren+json
     */
    public static final String CT_SIREN_JSON = "application/vnd.siren+json";

    /**
     * Content type text/html
     */
    public static final String CT_TEXT_HTML = "text/html";

    /**
     * Content type application/octet-stream
     */
    public static final String CT_OCTET_STREAM = "application/octet-stream";

    /**
     * JSON file extension.
     */
    public static final String EXT_JSON = ".json";

    /**
     * Service registration property defining the type of ResourceProvider
     * representing an API end point. The value is a string representing the
     * name of the API exposed under the context path.
     */
    public static final String ENDPOINTPROVIDER_TYPE = "endpointprovider.type";

    /**
     * Default response charset
     */
    public static final String DEFAULT_CHARSET = "UTF-8";

}
