package com.adobe.internal.io;

import java.io.IOException;
import java.nio.ByteBuffer;

/**
 * A {@link com.adobe.internal.io.ByteReader ByteReader} that wraps a
 * {@link java.nio.ByteBuffer ByteBuffer}.
 *
 * This class is <b>not</b> threadsafe.  It is not safe to pass an instance of this class
 * to multiple threads.  It is not safe to pass an instance of this class to multiple users even
 * if in the same thread.  It is not safe to give the same ByteBuffer to multiple instances
 * of this class.
 */
public class ByteBufferByteReader extends ByteReaderWrapperImpl
{	
	/**
	 * Create a new ByteBufferByteReader with the given {@link java.nio.ByteBuffer ByteBuffer}.
	 * The buffer is not copied.
	 * @param buffer the ByteBuffer to use.
	 * @throws IOException 
	 */
	public ByteBufferByteReader(ByteBuffer buffer) throws IOException
	{
		super(new ByteBufferByteWriter(buffer));
	}
	
	/**
	 * Create a new ByteBufferByteReader with the given byte array.
	 * The buffer is not copied but is wrapped with a ByteBuffer before use.
	 * @param b the byte array to use.
	 * @throws IOException 
	 * @see com.adobe.internal.io.ByteArrayByteReader
	 */
	public ByteBufferByteReader(byte[] b) throws IOException
	{
		this(ByteBuffer.wrap(b));
	}	
}
