/*************************************************************************
 *
 *	File: QRCodeImageBuilder.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.qrcodepmp;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

import com.adobe.xfa.pmp.qrcodepmp.denso.QRC;

/**
 * Ported from QRCodeImageBuilder.cpp
 */
class QRCodeImageBuilder {
	private QRC qrc;

	BufferedImage buildImage(int imageCols, // In: Desired columns in image.
			int imageRows, // In: Desired rows in image.
			int xDimension) throws QRCodeEncoderException // In: size of the
															// module.
	{
		if (imageCols <= 0)
			imageCols = (qrc.Csize + 8) * xDimension;
		if (imageRows <= 0)
			imageRows = (qrc.Csize + 8) * xDimension;

		// Center the symbol in the image
		int colOffset = (imageCols - (qrc.Csize * xDimension)) / 2;
		int rowOffset = (imageRows - (qrc.Csize * xDimension)) / 2;

		// Enforce quiet zone of 4 module widths all around.
		if ((colOffset < (4 * xDimension)) || (rowOffset < (4 * xDimension)))
			throw new QRCodeEncoderException(
					QRCodeEncoderErrorCode.IMAGE_TOO_SMALL);

		// Create the image
		BufferedImage image = new BufferedImage(imageCols, imageRows,
				BufferedImage.TYPE_BYTE_GRAY);
		Graphics2D graphicsBarcodeImage = image.createGraphics();
		graphicsBarcodeImage.setColor(Color.WHITE);
		graphicsBarcodeImage.fillRect(0, 0, Integer.MAX_VALUE,
				Integer.MAX_VALUE);

		graphicsBarcodeImage.clipRect(0, 0, imageCols - colOffset, imageRows
				- rowOffset);
		// Convert the X-sequence to rectangles in the image.
		int col;
		int row;
		Color color = Color.BLACK;
		int i;
		int j;

		for (i = 0, row = rowOffset; i < qrc.Csize; i++, row += xDimension) {
			for (j = 0, col = colOffset; j < qrc.Csize; j++, col += xDimension) {
				color = (qrc.mtstcell(j, i)) != 0 ? Color.BLACK : Color.WHITE;

				graphicsBarcodeImage.setColor(color);
				graphicsBarcodeImage.fillRect(col, row, col + xDimension, row
						+ xDimension);
			}
		}
		return image;
	}

	public void setQrc(QRC qrc) {
		this.qrc = qrc;
	}
}
