package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.ut.UnitSpan;

/**
 * @exclude from published api.
 */

class DispTab extends TextEmbed {
	private TextRegion mpoFillRegion;
	private UnitSpan moWidth = UnitSpan.ZERO;
	private UnitSpan moHeight = UnitSpan.ZERO;
	private UnitSpan moFillWidth;
	private boolean mbTrailing;

	DispTab () {
	}

	void setWidth (float oWidth) {
		setWidth (Units.toUnitSpan (oWidth));
	}

	void setWidth (UnitSpan oWidth) {
		moWidth = oWidth;
	}

	void setFillWidth (float oWidth) {
		moFillWidth = Units.toUnitSpan (oWidth);
	}

	UnitSpan getFillWidth () {
		return (moFillWidth == null) ? moWidth : moFillWidth;
	}

	void setHeight (UnitSpan oHeight) {
		moHeight = oHeight;
	}

	boolean isTrailing () {
		return mbTrailing;
	}

	void setTrailing (boolean bTrailing) {
		mbTrailing = bTrailing;
	}

	public void fill (TextContext poContext, TextAttr poMasterAttr, GFXEnv poGfxEnv) {
		assert (poMasterAttr != null);
		assert (poMasterAttr.leaderPatternEnable());
		assert ((poMasterAttr.leaderPattern() == TextAttr.LEADER_PATTERN_DOTS) || (poMasterAttr.leaderPattern() == TextAttr.LEADER_PATTERN_USE_CONTENT));
		assert (poMasterAttr.leaderContentEnable());

		mpoFillRegion = null;	// TODO: need a way to recycle these
		mpoFillRegion = new TextRegion();
		mpoFillRegion.fontService (poMasterAttr.fontService());
		mpoFillRegion.setContext (poContext);
		mpoFillRegion.allowNewLines (false);
		if (poMasterAttr.leaderPattern() == TextAttr.LEADER_PATTERN_DOTS) {
			mpoFillRegion.append (".");
		} else {
			mpoFillRegion.append (poMasterAttr.leaderContent());
		}

		mpoFillRegion.setMinWidth (UnitSpan.ZERO);
		mpoFillRegion.setMinHeight (UnitSpan.ZERO);

		UnitSpan oMax = new UnitSpan (UnitSpan.INCHES_72K, -1);
		mpoFillRegion.setMaxWidth (oMax);
		mpoFillRegion.setMaxHeight (oMax);

		mpoFillRegion.forceDisplay (poMasterAttr, poGfxEnv);
	}

	public TextRegion getFillRegion () {
		return mpoFillRegion;
	}

	public boolean isEqual (TextEmbed poCompare) {
		return true; // TBD?
	}

	public UnitSpan width () {
		return moWidth;
	}

	public UnitSpan height () {
		return moHeight;
	}

	public TextEmbed cloneEmbed () {
		return new DispTab();
	}

	public void gfxDraw (GFXEnv oEnv) {
	}

	public int embedAt () {
		return EMBED_AT_BOTTOM;
	}

	public String toString () {
		return "tab (" + moWidth.toString() + ")";
	}
}
