// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model.rules;

import com.adobe.xmp.schema.model.SchemaVisitor;
import com.adobe.xmp.schema.model.TypeRule;
import com.adobe.xmp.schema.model.XMPSchemaException;


/**
 * This rule applies for the type "Text" (string length) and 
 * all arrays (number of array items).
 * 
 * @author Stefan Makswit
 */
public class LengthRule implements TypeRule
{
	private static final long serialVersionUID = 1L;
	/** operator used to compare the operand with the actual length of either the XMP Text or 
	 *  an XMP array */
	private ComparisonOperator operator;
	/** the constant length value */
	private int operand;

	
	/**
	 * Constructs a new LengthRule.
	 *
	 * @param operator the comparison operator
	 * @param length the length to compare with
	 */
	public LengthRule(ComparisonOperator operator, int length)
	{
		this.operator = operator;
		this.operand = length;
	}


	/**
	 * @return Returns the operator.
	 */
	public ComparisonOperator getOperator()
	{
		return this.operator;
	}


	/**
	 * @return Returns the argument.
	 */
	public int getOperand()
	{
		return this.operand;
	}
	
	
	/**
	 * @see com.adobe.xmp.schema.model.TypeRule#accept(com.adobe.xmp.schema.model.SchemaVisitor)
	 */
	public void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException
	{
		schemaVisitor.visit(this);
	}
}
