/*
 * $Id: SpellCheckException.java 20173 2006-05-03 14:47:57Z tripod $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.spellchecker;

/**
 * Exception class
 */
public class SpellCheckException extends Exception {

    /** Root throwable */
    private Throwable root;

    /**
     * Create a new instance of this class.
     * @param msg message
     */
    public SpellCheckException(String msg) {
        super(msg);
    }

    /**
     * Create a new instance of this class.
     * @param msg message
     * @param root root throwable
     */
    public SpellCheckException(String msg, Throwable root) {
        super(msg);

        this.root = root;
    }

    /**
     * Return the root throwable
     * @return root throwable, may be <code>null</code>
     */
    public Throwable getRootException() {
        return root;
    }
}
