/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser.taghandlers;

import java.util.HashMap;
import java.util.Map;

import org.xml.sax.Attributes;

import com.day.cq.wcm.designimporter.DesignImporterContext;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.api.HTMLContentProvider;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerProvider;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;

/**
 * This tag handler is used to parse the metadata associated with the HTML page
 * via the meta tags.
 *
 * <p>
 * This tag handler is registered against the markup of type < meta >. That implies
 * this tag handler will come into action whenever the design importer framework
 * encounters an HTML tag matching the rule this handler is defined against.
 * </p>
 *
 * @see com.day.cq.wcm.designimporter.parser.taghandlers.factory.MetaTagHandlerFactory
 */
public class MetaTagHandler implements TagHandler, HTMLContentProvider {

    private String metaProperty;

    private String metaPropertyValue;

    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        metaProperty = atts.getValue("name");
        metaPropertyValue = atts.getValue("content");
    }

    public void characters(char[] ch, int start, int length) throws DesignImportException {

    }

    public void endElement(String uri, String localName, String qName) throws DesignImportException {

    }

    public void endHandling(String uri, String localName, String qName) {

    }

    public Object getContent(HTMLContentType htmlContentType) {
        Map<String, String> metadata = new HashMap<String, String>();
        if (metaProperty != null && metaPropertyValue != null) {
            metadata.put(metaProperty, metaPropertyValue);
        }
        return metadata;
    }

    public void setDesignImporterContext(DesignImporterContext designImporterContext) {

    }

    public void setTagHandlerProvider(TagHandlerProvider tagHandlerProvider) {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
    }

    public boolean supportsContent(HTMLContentType htmlContentType) {
        return htmlContentType == HTMLContentType.META;
    }

}
