/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.wcm.foundation.model.export;

import java.util.List;

/**
 * JSON serializable Interface to be used to serialize the Allowed Components.
 */
public interface AllowedComponentsExporter {

    /**
     * List of simple objects representing all Allowed Components for the given Resource
     * @return list of Allowed Components mapping
     */
    List getComponents();

    /**
     * Is the given resource contained by a page, with authored template structure,
     * and is the given resource set as editable (unlocked)
     * @return true if the template has structure support and the resource is editable, false otherwise
     */
    boolean isApplicable();
}
