/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2020 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

/**
 * This class defines the OOTB semantic types provided by Content Fragments.
 *
 * @since 1.7.0
 */
public final class SemanticDataType {

    private SemanticDataType() {
        // prevent instantiation
    }

    /**
     * Semantic type: Reference to another content fragment
     */
    public static final String CONTENT_FRAGMENT = "content-fragment";

    /**
     * Semantic type: Path reference
     */
    public static final String REFERENCE = "reference";

    /**
     * Semantic type: A JSON structure
     */
    public static final String JSON = "json";

    /**
     * Semantic type: A multiline text (with a certain content type)
     */
    public static final String MULTILINE = "multiline";

    /**
     * Semantic type: Date and time
     */
    public static final String DATETIME = "datetime";

    /**
     * Semantic type: Date only
     */
    public static final String DATE = "date";

    /**
     * Semantic type: Time only
     */
    public static final String TIME = "time";

    /**
     * Semantic type: Tag
     */
    public static final String TAG = "tag";

}
