/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.adobe.cq.dam.index.builder;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

@Deprecated
public class NullChkEnabledPropertyDefinition extends SimplePropertyDefinition {

    boolean nullChkEnabled;
    /**
     * Creates a simple PropertyDefinition for oak lucene index
     *
     * @param property property to index
     * @param nodeName PropertyDefinition node name
     * @param nullChkEnabled Whether nullCheckIsEnabled or not
     */
    public NullChkEnabledPropertyDefinition(String property, String nodeName, boolean nullChkEnabled) {
        super(property, nodeName);
        this.nullChkEnabled = nullChkEnabled;
    }

    /**
     * @param property property to index
     * @param nodeName property definition node name
     * @param boost    index time field boost factor
     * @param nullChkEnabled Whether nullCheckIsEnabled or not
     */
    public NullChkEnabledPropertyDefinition(String property, String nodeName, float boost, boolean nullChkEnabled) {
        super(property, nodeName, boost);
        this.nullChkEnabled = nullChkEnabled;
    }

    /**
     * @param property     property to index
     * @param nodeName     property definition node name
     * @param propertyType propertyType
     * @param nullChkEnabled Whether nullCheckIsEnabled or not
     */
    public NullChkEnabledPropertyDefinition(String property, String nodeName, String propertyType, boolean nullChkEnabled) {
        super(property, nodeName, propertyType);
        this.nullChkEnabled = nullChkEnabled;
    }

    /**
     * @param property     property to index
     * @param nodeName     property definition node name
     * @param boost    index time field boost factor
     * @param analyzed Whether analyzed or not
     * @param nullChkEnabled Whether nullCheckIsEnabled or not
     */
    public NullChkEnabledPropertyDefinition(String property, String nodeName, float boost, boolean analyzed, boolean nullChkEnabled) {
        super(property, nodeName, boost, analyzed);
        this.nullChkEnabled = nullChkEnabled;
    }

    public void setNullChkEnabled(boolean nullChkEnabled) {
        this.nullChkEnabled = nullChkEnabled;
    }

    @Override
    public void build(Resource resource) throws PersistenceException {
        super.build(resource);
        ResourceResolver resolver = resource.getResourceResolver();
        Node propDefNode = resolver.getResource(resource, nodeName).adaptTo(Node.class);
        try {
            propDefNode.setProperty(LuceneIndexConstants.PROP_NULL_CHECK_ENABLED, nullChkEnabled);
        } catch (RepositoryException e) {
            throw new PersistenceException("got an "
                    + e.toString() + "rethrowing as PersistenceException");
        }
    }
}
