/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package com.adobe.cq.dam.mac.sync.helper;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public interface MACTenantConfigurationResolver {

    /**
     * JCR Property on a folder ( {@code nt:folder} / {@code sling:Folder} / {@code sling:OrderedFolder} ) identifying the MAC cloud service
     * configuration for a target folder.
     */
    public static final String JCR_PROP_MAC_CLOUDSERVICE_CONFIG = "macConfig";

    /**
     * JCR Property on a folder ( {@code nt:folder} / {@code sling:Folder} / {@code sling:OrderedFolder} ) identifying the MP cloud service
     * configuration for a target folder.
     */
    public static final String JCR_PROP_MP_CLOUDSERVICE_CONFIG = "mpConfig";

    /**
     * Retrieves the cloud configuration described by the resource stored under the provided {@code path}. If no configuration is found at
     * that path this method returns {@code null}.
     *
     * @param resolver the resource resolver used to access the resources
     * @param path the path from which to obtain the configuration
     * @return the configuration if found, {@code null} otherwise
     */
    MACTenantConfiguration getConfiguration(ResourceResolver resolver, String path);

    /**
     * Retrieves a {@link MACTenantConfiguration} for a {@link Resource}. The configuration is retrieved by recursively looking for the
     * {@link MACTenantConfigurationResolver#JCR_PROP_MAC_CLOUDSERVICE_CONFIG} property on the resource or its parents.
     *
     * @param resource the {@link Resource} to look for configuration. The resource's resolver is used for accessing the resources.
     * @return the configuration if found, {@code null} otherwise
     */
    MACTenantConfiguration getConfigurationForResource(Resource resource);

    /**
     * Retrieves a {@link MACTenantConfiguration} for a {@link Resource}. The configuration is retrieved by recursively looking for the
     * {@link MACTenantConfigurationResolver#JCR_PROP_MP_CLOUDSERVICE_CONFIG} property on the resource or its parents.
     *
     * @param resource the {@link Resource} to look for configuration. The resource's resolver is used for accessing the resources.
     * @return the configuration if found, {@code null} otherwise
     */
    MACTenantConfiguration getMPConfigurationForResource(Resource resource);

    /**
     * Retrieves a {@link MACTenantConfiguration} for a {@code path}. The configuration is retrieved by recursively looking for the
     * {@link MACTenantConfigurationResolver#JCR_PROP_MAC_CLOUDSERVICE_CONFIG} property on the resource at the indicated path or its parents.
     *
     * @param resolver the resource resolver used to access the resources
     * @param path the path
     * @return the configuration if found, {@code null} otherwise
     */
    MACTenantConfiguration getConfigurationForPath(ResourceResolver resolver, String path);

    /**
     * Retrieves a {@link MACTenantConfiguration} for a {@code path}. The configuration is retrieved by recursively looking for the
     * {@link MACTenantConfigurationResolver#JCR_PROP_MP_CLOUDSERVICE_CONFIG} property on the resource at the indicated path or its parents.
     *
     * @param resolver the resource resolver used to access the resources
     * @param path the path
     * @return the configuration if found, {@code null} otherwise
     */
    MACTenantConfiguration getMPConfigurationForPath(ResourceResolver resolver, String path);

    /**
     * returns the first enabled config from available configs.
     *
     * @param resolver the resource resolver used to access the resources
     * @return
     */
    MACTenantConfiguration getDefaultConfig(ResourceResolver resolver);

    /**
     * returns the first enabled MP config from available configs.
     *
     * @param resolver the resource resolver used to access the resources
     * @return
     */
    MACTenantConfiguration getDefaultMPConfig(ResourceResolver resolver);

}
