/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.msm.ui.models.blueprintconfig;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.wcm.api.Page;

@Model(adaptables = SlingHttpServletRequest.class)
public class BlueprintColumnItem {

    @ScriptVariable
    private Resource resource;

    private boolean isPage;

    private String imgSrc;

    private String title;

    private Map<String, String>  itemAttrb;

    @ScriptVariable
    private XSSAPI xssAPI;

    @Self
    private SlingHttpServletRequest request;


    @PostConstruct
    public void postConstruct() throws Exception {
        Page page = resource.adaptTo(Page.class);
        isPage = false;
        if (page != null) {
            isPage = true;
            imgSrc = xssAPI.getValidHref(request.getContextPath() + getThumbnailUrl(page, 48, 48));
            title = page.getTitle() == null ? page.getName() : page.getTitle();
        } else {
            ValueMap resourceValueMap = resource.getValueMap();
            title = resourceValueMap.get(JcrConstants.JCR_CONTENT + "/" + JcrConstants.JCR_TITLE, resourceValueMap.get(JcrConstants.JCR_TITLE, resource.getName()));
        }
        title = xssAPI.encodeForHTML(title);

        itemAttrb = new HashMap<String, String>();
        itemAttrb.put("class","foundation-collection-item coral3-ColumnView-item" );
        itemAttrb.put("data-foundation-collection-item-id", resource.getPath());
        itemAttrb.put("data-granite-collection-item-id", resource.getPath());
        if (resource.hasChildren()) {
            itemAttrb.put("variant", "drilldown");
        }
    }

    public boolean isPage() {
        return isPage;
    }

    public boolean isValidSelection() {
        return isPage;
    }

    public String getImageSource() {
        return imgSrc;
    }

    public Map<String, String> getItemAttrb() {
        return itemAttrb;
    }

    public String getTitle() {
        return title;
    }

    private String getThumbnailUrl(Page page, int width, int height) {
        String ck = "";

        ValueMap metadata = page.getProperties("image/file/jcr:content");
        if (metadata != null) {
            Calendar cal = metadata.get("jcr:lastModified", Calendar.class);
            if (cal != null) {
                ck = "" + (cal.getTimeInMillis() / 1000);
            }
        }

        return Text.escapePath(page.getPath()) + ".thumb." + width + "." + height + ".png?ck=" + ck;
    }

}
