/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.cq.remote.content.renderer;

import java.io.IOException;

import javax.annotation.Nonnull;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.annotation.versioning.ProviderType;

/**
 * Interface for Osgi Service to get content rendered from the Remote Server
 */
@ProviderType
public interface RemoteContentRenderingService {

    /**
     * Creates a Remote Request  using the config from Sling Servlet Request and provides the Response object after executing it on the Remote Content Rendering Server
     * @param request The AEM internal servlet request
     * @return The {@link CloseableHttpResponse} Object
     * @throws RemoteContentRenderingException
     * @throws IOException
     */
    @Nonnull
    CloseableHttpResponse getRemoteContentResponse(@Nonnull SlingHttpServletRequest request) throws RemoteContentRenderingException, IOException;

}
