/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.adobe.cq.xf;

import org.osgi.annotation.versioning.ProviderType;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.webservicesupport.Configuration;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ValueMap;

import java.util.List;

/**
 * Model object that represents an experience fragment variation
 */
@ProviderType
public interface ExperienceFragmentVariation extends Adaptable{

    /**
     * Retrieves the path of this experience fragment variation
     * @return the path of the underlying page
     */
    String getPath();

    /**
     * Retrieves the parent Experience Fragment for this variation
     * @return a {@link ExperienceFragment} object
     */
    ExperienceFragment getParent();

    /**
     * Returns the type of this experience fragment variation.
     * @return a String representing the type of this variation
     */
    String getType();

    /**
     * Retrieves the properties of this variation
     * @return a {@link ValueMap} object
     */
    ValueMap getProperties();

    /**
     * Retrieves the inherited properties of this variation.
     * @return an {@link InheritanceValueMap} which also contain the properties of the parent Experience Fragment
     */
    InheritanceValueMap getPropertiesTree();

    /**
     * Retrieves a list of cloud services configurations attached to this variation
     * @return a list of {@link Configuration} objects pointing to their respective cloud service configurations
     */
    List<String> getCloudserviceConfigurationsPaths();

}
