/*
 *
 *	File: InvalidGlyphException.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 */

package com.adobe.fontengine.font;

import com.adobe.fontengine.font.InvalidFontException;

/**
 * The charstring associated with the glyph cannot be interpreted.
 * 
 * <h4>Synchronization</h4>
 * 
 * <p>This class has the same threadsafety guarantees java.lang.Exception.</p>
 */
public class InvalidGlyphException extends InvalidFontException {
 
    static final long serialVersionUID = 1;

    public InvalidGlyphException () {
      super ();
    }

    public InvalidGlyphException (Font font) {
      super (font);
    }

    public InvalidGlyphException (String message) {
      super (message);
    }

    public InvalidGlyphException (String message, Font font) {
      super (message, font);
    }

    public InvalidGlyphException (String message, Throwable cause) {
        super (message, cause);
    }

    public InvalidGlyphException (String message, Throwable cause, Font font) {
        super (message, cause, font);
    }

    public InvalidGlyphException (Throwable cause) {
        super (cause);
    }

    public InvalidGlyphException (Throwable cause, Font font) {
        super (cause, font);
    }
}
