/**
 * 
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.UnsupportedFontException;

public class NameKeyedSubset extends SubsetDefaultImpl
{
	  public NameKeyedSubset (int numGlyphs, boolean doSubset) 
	  throws InvalidFontException, UnsupportedFontException {
		  super(numGlyphs, doSubset);
	  }
	  
	  public void addGlyphs(NameKeyedFont font, String[] glyphNames)
	  	throws InvalidFontException, UnsupportedFontException
	  {
			for (int i = 0; i < glyphNames.length; i++) {
				String glyphName = glyphNames[i];				// Subset arrives empty in this case
				if (glyphName != null) {
					int fullGid = font.glyphName2gid(glyphName);
					if (fullGid == 0 && !glyphName.equals(".notdef"))
						throw new InvalidFontException("Font does not contain required codepoint");
					getSubsetGid(fullGid);				// Add to subset if not done yet
				}
			}
	  }
}