/*
 * Type1CStringConsumerDefault
 *
  * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.HintedOutlineConsumer;
import com.adobe.fontengine.font.Matrix;

/**
 * The default implementation of a type1 charstring consumer, which simply
 * eats all of the charstring information.
 *
 * <h4>Synchronization</h4>
 * 
 * This class contains no instance data or mutable static data. 
 * It is therefore threadsafe.
 */
public class Type1CStringConsumerDefault implements HintedOutlineConsumer {
    
    public void setMatrix(Matrix newMatrix)
    {
        // do nothing
    }
    
    public void globalColorOn()
    {
        // do nothing
    }
    
    public void noCounters()
    {
        // do nothing
    }
    
    public void noHints()
    {
        // do nothing
    }
    
	public void stem(double edge1, double edge2, boolean doHintSubstitution, boolean vertical, boolean isCounter) 
	{
		// do nothing
	}


	public void stem3(double edge1, double edge2, double edge3, double edge4,
			double edge5, double edge6, boolean doHintSubstitution, boolean isVertical) {
		// do nothing

	}



	public boolean width(double wx) {
		// continue upon return...
		return true;
	}

	public void lineto(double x, double y) {
		// do nothing

	}

	public void curveto(double x1, double y1, double x2, double y2, double x3,
			double y3) {
		// do nothing

	}

    public void curveto(double x1, double y1, double x2, double y2) {
        // do nothing
    }
    
	public void moveto(double x, double y) {
		// do nothing

	}

	public void flex(double depth, double x1, double y1, double x2, double y2,
			double x3, double y3, double x4, double y4, double x5, double y5,
			double x6, double y6) {
		// do nothing

	}
	
	public void closepath() {
	    // do nothing
	}
	
	public void endchar() {
	    // do nothing
	}


}
