/*
 * File: DigitWidth.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.inlineformatting;

/** Enumerated values for {@link ElementAttribute#digitWidth}.
 * 
 * Some fonts provide digits in multiple widths: tabular digits all share
 * a single width, and are appropriate for setting in tables, where the 
 * digits should be aligned; proportional digits have varying widths and
 * are appropriate for setting in running text.
 * 
 * This class provides constants corresponding to this distinction.
 */
final public class DigitWidth {

  private final String name;
  
  private DigitWidth (String name) {
    this.name = name;
  }
  
  public String toString () {
    return name;
  }
  
  /** Tabular digits.
   */
  public static final DigitWidth TABULAR = new DigitWidth ("TABULAR");
  
  /** Proportional digits.
   */
  public static final DigitWidth PROPORTIONAL = new DigitWidth ("PROPORTIONAL");
  
  /** Fonts default.
   * 
   * This value can be used to request the default width setting, as 
   * determined by the font designer.
   */
  public static final DigitWidth DEFAULT = new DigitWidth ("DEFAULT");
  
  
  private static final DigitWidth[] allValues 
  = {TABULAR, PROPORTIONAL, DEFAULT};
  
  public static DigitWidth parse (String s) {
    for (int i = 0; i < allValues.length; i++) {
      if (allValues [i].name.compareToIgnoreCase (s) == 0) {
        return allValues [i]; }}
    return null;
  }
}
