/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api.description;

import org.osgi.annotation.versioning.ProviderType;

import com.adobe.granite.haf.annotations.ApiLink;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/**
 * A description of a link defined in the model.
 */
@ProviderType
public interface LinkDescription {
    /**
     * Get the hrefs defined in the link.
     * @return The hrefs.
     */
    @Nonnull
    Iterable<String> getHref();

    /**
     * Get the relation defined in the link.
     * @return The link's relation
     */
    @Nonnull
    String getRelation();

    /**
     * Get the scope of the link.  The scope can be used to decide when to serialize the link.  Whether it is
     * serialized for a main entity, a child entity or both.
     * @return The links scope.
     */
    @Nonnull
    ApiLink.SCOPE getScope();

    /**
     * Get the content type of the content delivered when following the link.
     * @return The content type.
     */
    @CheckForNull
    String getContentType();

    /**
     * Get whether the link should be considered absolute or not.
     * @return Whether the link is absolute or not.
     */
    boolean isAbsolute();
}
